package com.tykj.dev.device.scrap.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author dengdiyi
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "报废单上传类", description = "报废单上传类")
public class UploadVo {

    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(value = "任务id")
    private Integer taskId;

    @NotNull(message = "fileName不能为空")
    @ApiModelProperty(value = "报废单名字")
    private String fileName;

    @NotNull(message = "fileUrl不能为空")
    @ApiModelProperty(value = "报废单路径")
    private String fileUrl;

    @ApiModelProperty(value = "监销人")
    private String supervisor;

    @ApiModelProperty(value = "主管领导")
    private String leader;

    @ApiModelProperty(value = "承办人")
    private String undertaker;

}
