package com.tykj.dev.device.selfcheck.subject.vo;

import com.tykj.dev.device.file.entity.FileRet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("自查审核类")
public class SelfCheckConfirmVo {

    @ApiModelProperty(value = "检查附件名")
    private List<FileRet> checkFiles;

    @NotNull(message = "taskId不能为空")
    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(name = "任务Id")
    private Integer taskId;

    @NotNull(message = "status不能为空")
    @Min(value = 0,message = "status不能小于0")
    @ApiModelProperty(name = "需要修改的状态", example = "0", value = "0为审核通过,1为驳回")
    private Integer status;

    @ApiModelProperty(name = "审核人ID", example = "1")
    private Integer userbId;
}
