package com.tykj.dev.device.sendback.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.sendback.entity.domain.DeviceRepel;
import com.tykj.dev.device.sendback.entity.vo.*;
import com.tykj.dev.device.sendback.service.AgainStorageBillService;
import com.tykj.dev.device.sendback.service.RepelBusinessService;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelDevController.java
 * @Description TODO
 * @createTime 2021年01月10日 13:52:00
 */
@RestController
@Api(tags = "装备清退（新）", description = "包括装备清退、装备异常处理、装备出库、装备入库")
@AutoDocument
@RequestMapping("/repel")
public class RepelDevController {
    @Autowired
    RepelBusinessService repelBusinessService;

    @Autowired
    AgainStorageBillService againStorageBillService;

    @PostMapping(value ="/initiateRepel/{userId}")
    @ApiOperation(value = "省发布清退接口", notes = "省发布清退接口")
    public ResponseEntity initiateRepel(@PathVariable Integer userId,@RequestBody DeviceRepel deviceRepel){
        repelBusinessService.initiateRepel(deviceRepel,userId);
    return ResponseEntity.ok("发布成功");
    }

    @ApiOperation(value = "市转发省级任务接口", notes = "市转发省级任务接口")
    @PostMapping(value ="/resolveRepel/{userId}/{taskId}")
    public ResponseEntity resolveRepel(@PathVariable Integer userId, @RequestBody DeviceRepel deviceRepel, @PathVariable Integer taskId){
        repelBusinessService.resolveRepel(deviceRepel, taskId, userId);
        return ResponseEntity.ok("市转发省级任务成功");
    }

    @ApiOperation(value = "提交任务等待审核", notes = "选择装备的接口")
    @PostMapping(value ="/resolveConfirm/{userId}/{taskId}")
    public ResponseEntity resolveConfirm(@PathVariable Integer userId,  @PathVariable Integer taskId){
        repelBusinessService.resolveConfirm(taskId,userId);
        return ResponseEntity.ok("提交任务成功，等待审核");
    }

    @ApiOperation(value = "提交选择则的装备", notes = "选择装备的接口")
    @PostMapping(value ="/submitChoose/{taskId}")
    public ResponseEntity resolveConfirm1( @RequestBody ResolveConfirm resolveConfirm, @PathVariable Integer taskId){
        repelBusinessService.submitChooseDevice(taskId,resolveConfirm);
        return ResponseEntity.ok("选中装备提交成功");
    }

    @ApiOperation(value = "清退代办业务审核接口", notes = "清退代办业务审核接口")
    @PostMapping(value ="/resolveAudit/{taskId}")
    public ResponseEntity resolveAudit(@PathVariable Integer taskId, @RequestBody RepelAuditResult repelAuditResult){
        repelBusinessService.resolveAudit(taskId,repelAuditResult);
        return ResponseEntity.ok("审核成功");
    }

    @ApiOperation(value = "清退出库任务接口", notes = "清退出库任务接口")
    @PostMapping(value ="/sendBackOutCheck/{userId}/{taskId}")
    public ResponseEntity sendBackOutCheck(@PathVariable Integer taskId, @RequestBody OrderOutData orderOutData, @PathVariable Integer userId){
        return ResponseEntity.ok(repelBusinessService.sendBackOutCheck(taskId,userId,orderOutData));
    }

    @ApiOperation(value = "清退入库任务接口", notes = "清退入库任务接口")
    @PostMapping(value ="/storageDeviceRepel/{taskId}")
    public ResponseEntity storageDeviceRepel(@PathVariable Integer taskId, @RequestBody StorageDeviceRepel storageDeviceRepel){
        repelBusinessService.storageDeviceRepel(taskId,storageDeviceRepel);
        return ResponseEntity.ok("入库任务");
    }

    @ApiOperation(value = "省本级清退任务", notes = "省本级清退任务")
    @PostMapping(value ="/oneselfRepel/{taskId}/{userId}")
    public ResponseEntity oneselfRepel(@PathVariable Integer taskId, @RequestBody StorageDeviceRepel storageDeviceRepel, @PathVariable Integer userId){
        repelBusinessService.oneselfRepel(taskId, storageDeviceRepel, userId);
        return ResponseEntity.ok("入库任务");
    }

    @ApiOperation(value = "市发起清退任务", notes = "市发起清退任务")
    @PostMapping(value ="/cityInitiateRepel/{userId}")
    public ResponseEntity cityInitiateRepel(@PathVariable Integer userId, @RequestBody DeviceRepel deviceRepel){
        repelBusinessService.cityInitiateRepel(deviceRepel,userId);
        return ResponseEntity.ok("省上传中办回执单,成功任务结束");
    }

    @ApiOperation(value = "省审核市清退任务", notes = "省审核市清退任务")
    @PostMapping(value ="/provinceAuditCity/{taskId}/{userId}")
    public ResponseEntity provinceAuditCity(@PathVariable Integer taskId,@PathVariable Integer userId, @RequestBody RepelAuditResult repelAuditResult){
        repelBusinessService.provinceAuditCity(taskId,userId,repelAuditResult);
        return ResponseEntity.ok("省上传中办回执单,成功任务结束");
    }

    @ApiOperation(value = "统计清退任务的办结", notes = "统计清退任务的办结")
    @GetMapping(value ="/repelEnd/{taskId}")
    public ResponseEntity cityRepelEnd(@PathVariable Integer taskId){
        repelBusinessService.cityRepelEnd(taskId);
        return ResponseEntity.ok("统计清退任务的办结");
    }

    @ApiOperation(value = "省直属任务待清退", notes = "省直属任务待清退")
    @GetMapping(value ="/provinceDirectlyUnder/{taskId}")
    public ResponseEntity provinceDirectlyUnder(@PathVariable Integer taskId,@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser){
        repelBusinessService.provinceDirectlyUnder(taskId,securityUser);
        return ResponseEntity.ok("省直属单位任务提交成功");
    }

    @ApiOperation(value = "清退装备任务等待上传回执单", notes = "上传回执单 也可以不上传回执单")
    @PostMapping(value ="/receipts")
    public ResponseEntity receipts( @RequestBody StorageDeviceRepel storageDeviceRepel){
        repelBusinessService.receipts(storageDeviceRepel);
        return ResponseEntity.ok("上传回执单成功");
    }

    @ApiOperation(value = "清退出入库发件方选择签发人接口", notes = "上传回执单 也可以不上传回执单")
    @PostMapping(value ="/addSendBUser")
    public ResponseEntity addSendBUser( @RequestBody StorageDeviceRepel storageDeviceRepel){
        repelBusinessService.addSendBUser(storageDeviceRepel);
        return ResponseEntity.ok("签发人选择成功");
    }

    @ApiOperation(value = "装备生命状态转换接口-会生成业务记录", notes = "装备生命状态转换接口-会生成业务记录")
    @PostMapping(value ="/transitionOfLife/business")
    public ResponseEntity transitionOfLife(@RequestBody TransitionOfLifeVo transitionOfLifeVo,@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser){
        againStorageBillService.againPutInStorage(transitionOfLifeVo,securityUser);
        return ResponseEntity.ok("装备生命状态转换成功");
    }

    @ApiOperation(value = "测试", notes = "上传回执单 也可以不上传回执单")
    @PostMapping(value ="/test")
    public ResponseEntity receipts1(){
        return ResponseEntity.status(303).body("test");
    }

}
