package com.tykj.dev.device.sendback.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.sendback.entity.vo.DeviceIdLIstVo;
import com.tykj.dev.device.sendback.entity.vo.ModelAndTypeVo;
import com.tykj.dev.device.sendback.entity.vo.RepelManagementVo;
import com.tykj.dev.device.sendback.entity.vo.SendBackOutFormVo;
import com.tykj.dev.device.sendback.service.AgainStorageBillService;
import com.tykj.dev.device.sendback.service.RepelQueryService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.vo.TaskSelectVo;
import com.tykj.dev.device.task.subject.vo.TaskUserVo;
import com.tykj.dev.device.task.utils.TaskUtils;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.misc.utils.PageUtil;
import com.tykj.dev.misc.utils.ResultUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelQueryController.java
 * @Description 装备清退查询接口提供
 * @createTime 2021年01月10日 15:43:00
 */
@RestController
@Api(tags = "装备清退查询接口模块", description = "包括装备清退、装备异常处理、装备出库、装备入库")
@AutoDocument
@RequestMapping("/repelQuery")
public class RepelQueryController {
    @Autowired
    RepelQueryService repelQueryService;

    @Autowired
    TaskService taskService;

    @Autowired
    AgainStorageBillService againStorageBillService;

    @Autowired
    TaskUtils taskUtils;

    @GetMapping(value ="/repelTaskStatistical/{taskId}/{billId}")
    @ApiOperation(value = "省、市清退任务的统计页面详情", notes = "省、市清退任务的统计页面")
    public ResponseEntity findRepelTaskStatisticals(@PathVariable Integer taskId, @PathVariable Integer billId){
        return ResponseEntity.ok(repelQueryService.findRepelTaskStatisticals(taskId, billId));
    }

    @GetMapping(value ="/deviceRepelDetail/{taskId}")
    @ApiOperation(value = "统计任务审核页面详情", notes = "统计任务审核页面详情")
    public ResponseEntity findDeviceRepelDetail(@PathVariable Integer taskId){
        return ResponseEntity.ok(repelQueryService.findDeviceRepelDetail(taskId));
    }

    @GetMapping(value ="/deviceRepel/{taskId}")
    @ApiOperation(value = "代办任务通知页面详情", notes = "代办任务通知页面详情")
    public ResponseEntity findDeviceRepel(@PathVariable Integer taskId){
        return ResponseEntity.ok(repelQueryService.findDeviceRepel(taskId));
    }

    @PostMapping(value ="/deviceChooseRepel/{unitId}/{taskId}")
    @ApiOperation(value = "代办任务通知页面详情", notes = "代办任务通知页面详情")
    public ResponseEntity findDeviceRepel(@RequestBody List<Integer> fielding, @PathVariable Integer unitId, @PathVariable Integer taskId){
        return ResponseEntity.ok(repelQueryService.findDeviceChooseRepel(fielding,unitId,taskId));
    }

    @PostMapping(value ="/deviceChooseRepel1/{unitId}")
    @ApiOperation(value = "省本级任务清退装备查询接口", notes = "省本级任务清退装备查询接口")
    public ResponseEntity findDeviceRepel1(@RequestBody List<Integer>  fielding, @PathVariable Integer unitId){
        return ResponseEntity.ok(repelQueryService.findDeviceChooseRepel1(fielding,unitId));
    }

    @GetMapping(value ="/deviceSendOut/{taskId}")
    @ApiOperation(value = "出库查询装备", notes = "代办任务通知页面详情")
    public ResponseEntity findDeviceSendOut(@PathVariable Integer taskId){
        return ResponseEntity.ok(repelQueryService.findDeviceSendOut(taskId));
    }

    @PostMapping(value ="/toRepelList")
    @ApiOperation(value = "待清退列表", notes = "待清退列表")
    public ResponseEntity toRepelList(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(repelQueryService.repelDeviceList(repelManagementVo));
    }

    @PostMapping(value ="/clearedList")
    @ApiOperation(value = "已清退列表", notes = "已清退列表")
    public ResponseEntity clearedList(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(repelQueryService.clearedList(repelManagementVo));
    }

    @PostMapping(value ="/retiredList")
    @ApiOperation(value = "已退役列表", notes = "已退役列表接口")
    public ResponseEntity retiredList(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(repelQueryService.retiredList(repelManagementVo));
    }

    @GetMapping(value ="/provinceDirectlyUnderDev/{taskId}")
    @ApiOperation(value = "省直属任务单位列表查询接口", notes = "省直属任务装备查询接口")
    public ResponseEntity provinceDirectlyUnderDev(@PathVariable Integer taskId){
        return ResponseEntity.ok(repelQueryService.directlyUnderUnitLeftNavigation(taskId));
    }

    @PostMapping(value ="/repelManagementListDetails")
    @ApiOperation(value = "清退管理页面 统计列表数据点击接口", notes = "清退管理页面 统计列表数据点击接口")
    public ResponseEntity repelManagementListDetails(@RequestBody DeviceIdLIstVo deviceIdLIstVo){

        return ResponseEntity.ok(repelQueryService.repelManagementListDetails(deviceIdLIstVo.getIds()));
    }

    @GetMapping(value ="/provinceDirectlyUnderSelectedDev/{taskId}/{unitId}")
    @ApiOperation(value = "省直属单位 待上传接口装备查询", notes = "省直属单位 待上传接口装备查询")
    public ResponseEntity provinceDirectlyUnderSelectedDev( @PathVariable Integer taskId, @PathVariable Integer unitId){
        return ResponseEntity.ok(repelQueryService.provinceDirectlyUnderSelectedDev(taskId,unitId));
    }

    @PostMapping(value ="/findRepelListModelNameGroup")
    @ApiOperation(value = "清退管理 选择装备列表的接口", notes = "清退管理 选择装备列表的接口")
    public ResponseEntity findRepelListModelNameGroup(@RequestBody ModelAndTypeVo modelAndTypeVo){
        return ResponseEntity.ok(repelQueryService.findRepelListModelNameGroup(modelAndTypeVo));
    }

    @ApiOperation(value = "查询清退单列表")
    @GetMapping("/getList")
    public ResponseEntity getList(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser) {
        return ResponseEntity.ok(repelQueryService.getList(securityUser));
    }

    @ApiOperation(value = "查询清退任务", notes = "可以通过这个接口查询查询清退任务")
    @PostMapping(value = "/taskList")
    public ResponseEntity selectRepairTasks(@RequestBody TaskSelectVo taskSelectVo){
        List<TaskUserVo> taskUserVos = taskService.getManageList(taskSelectVo).stream().filter(taskUserVo -> taskUserVo.getBusinessType()==18||taskUserVo.getBusinessType()==16).collect(Collectors.toList());
        return ResultUtil.success(PageUtil.getPerPage(taskSelectVo.getPage(), taskSelectVo.getSize(), taskUtils.orderByTopDesc(taskUserVos), taskSelectVo.getPageable()));
    }

    @PostMapping(value ="/clearedDeviceList")
    @ApiOperation(value = "已清退", notes = "已清退列表")
    public ResponseEntity clearedList3(@RequestBody RepelManagementVo repelManagementVo){
        return ResponseEntity.ok(repelQueryService.clearedDeviceList(repelManagementVo));
    }

    @PostMapping(value ="/againStorage/{taskId}")
    @ApiOperation(value = "重新入库查询业务详情", notes = "重新入库查询业务详情")
    public ResponseEntity findAgainStorage(@PathVariable Integer taskId){
        return ResponseEntity.ok(againStorageBillService.findByid(taskId));
    }

}
