package com.tykj.dev.device.sendback.entity.domain;

import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.misc.base.BaseEntity;
import com.tykj.dev.misc.base.BusinessEnum;
import com.tykj.dev.misc.base.StatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Transient;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName AgainStorageBill.java
 * @Description TODO
 * @createTime 2021年03月16日 16:27:00
 */
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@EntityListeners(AuditingEntityListener.class)
@ApiModel("重新入库业务")
public class AgainStorageBill extends BaseEntity {

    @Column(name = "dev_ids", columnDefinition = "TEXT")
    private String DevIds;

    @ApiModelProperty(value = "转换类型 0.重新入库 1.转为待报废设备 2.转为待销毁设备 3.转为待退役设备")
    private Integer type;

    @Transient
    private List<DeviceLibrary> deviceLibraries;

    public AgainStorageBill(String devIds) {
        DevIds = devIds;
    }

    public AgainStorageBill(String devIds, Integer type) {
        DevIds = devIds;
        this.type = type;
    }
}
