package com.tykj.dev.device.sendback.entity.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.file.entity.Documents;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceRepel.java
 * @Description DeviceRepel 清退业务id
 * @createTime 2021年01月06日 20:02:00
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@ApiModel("清退详情")
public class DeviceRepelDetail extends BaseEntity {
    /**
     * 主键id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    /**
     * 账单id
     */
    @ApiModelProperty(value = "账单id")
    private Integer repelId;

    /**
     * 标题
     */
    @ApiModelProperty(value = "单据编号")
    private String title;

    /**
     * 编号
     */
    @ApiModelProperty(value = "单据编号")
    private String num;

    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

    @ApiModelProperty(value = "批复文号")
    private String replayNumber;
    /**
     * 发件单位
     */
    @ApiModelProperty(value = "发件单位")
    private String sendUnit;

    /**
     * 发件单位id
     */
    @ApiModelProperty(value = "发件单位id")
    private Integer sendUnitId;

    /**
     * 收件单位id
     */
    @ApiModelProperty(value = "收件单位id")
    private Integer receiveUnitId;
    /**
     * 收件单位
     */
    @ApiModelProperty(value = "收件单位")
    private String receiveUnit;
    /**
     * 配发时间
     */
    @ApiModelProperty(value = "配发时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sendTime;
    /**
     * 接收时间
     */
    @ApiModelProperty(value = "接收时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date receiveTime;
    /**
     * 经办人
     */
    @ApiModelProperty(value = "发件方id(A岗位)")
    private Integer sendUseraId;

    /**
     * 经办人 名称
     */
    @ApiModelProperty(value = "发件方名称(A岗位)")
    private String senderUserA;

    /**
     * 签发人
     */
    @ApiModelProperty(value = "签发人(B岗位)")
    private String senderUserB;

    /**
     * 签发人
     */
    @ApiModelProperty(value = "签发人(B岗位)")
    private Integer sendUserbId;
    /**
     * 收件方 经办人
     */
    @ApiModelProperty(value = "收件方id(A岗位)")
    private Integer receiveUseraId;

    /**
     * 收件方 经办人名称
     */
    @ApiModelProperty(value = "收件方名称(A岗位)")
    private String receiveUserA;

    /**
     * 收件方id(B岗位)
     */
    @ApiModelProperty(value = "收件方名称(B岗位)")
    private String receiveUserB;
    /**
     * 收件方id(B岗位)
     */
    @ApiModelProperty(value = "收件方id(B岗位)")
    private Integer receiveUserbId;

    /**
     * 出库附件文件
     */
    @ApiModelProperty(value = "出库附件文件")
    @Column(name = "outbound_file",columnDefinition = "TEXT")
    private String outboundFile;

    /**
     * 清退单文件
     */
    @ApiModelProperty(value = "清退单文件")
    @Column(name = "bill_file",columnDefinition = "TEXT")
    private String billFile;

    /**
     * 入库确认单
     */
    @ApiModelProperty
    @Column(name = "in_file",columnDefinition = "TEXT")
    private String inFile;

    /**
     * 退回状态(1:退回待审核,2:退回审核失败,3:退回中,4:退回接收待审核,5:退回接收审核失败,6:退回成功)
     */
    @ApiModelProperty(value = "退回状态(1:退回待审核,2:退回审核失败,3:退回中,4:退回接收待审核,5:退回接收审核失败,6:退回成功)")
    private Integer sendBackStatus;
    /**
     * 退回装备数量
     */
    @ApiModelProperty(value = "退回装备数量")
    private Integer sendBackCount;
    /**
     * 已出库装备数量
     */
    @ApiModelProperty(value = "已出库装备数量")
    private Integer sendedCount;
    /**
     * 已接收装备数量
     */
    @ApiModelProperty(value = "已接收装备数量")
    private Integer receiveCount;
    /**
     * 出库检查详情(装备主键id+核对结果(0缺失1无误3新增,字符x作为分隔符)),例如x10x21x32x,意为主键id为1的装备缺失,为2的无误,为3的不匹配
     */
    @Column(name = "send_check_detail",columnDefinition = "TEXT")
    @ApiModelProperty(value = "出库检查详情(装备主键id+核对结果(0缺失1无误3新增,字符x作为分隔符)),例如x10x21x32x,意为主键id为1的装备缺失,为2的无误,为3的不匹配")
    private String sendCheckDetail;
    /**
     * 出库检查结果(缺失数量x新增数量),例如1x1,意为缺失1台,新增一条
     */
    @ApiModelProperty(value = "出库检查结果(缺失数量x新增数量),例如1x1,意为缺失1台,新增一条")
    @Column(name = "send_check_result",columnDefinition = "TEXT")
    private String sendCheckResult;

    /**
     * 接收方入库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如x10x21x32x,意为主键id为1的装备缺失,为2的无误,为3的不匹配
     */
    @ApiModelProperty(value = "接收方入库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如x10x21x32x,意为主键id为1的装备缺失,为2的无误,为3的不匹配")
    @Column(name = "receive_check_detail",columnDefinition = "TEXT")
    private String receiveCheckDetail;

    /**
     * 接收方检查结果(缺失数量x新增数量),例如1x1,意为缺失1台,新增一条
     */
    @ApiModelProperty(value = "接收方检查结果(缺失数量x新增数量),例如1x1,意为缺失1台,新增一条")
    @Column(name = "receive_check_result",columnDefinition = "TEXT")
    private String receiveCheckResult;

    @ApiModelProperty(value = "装备id集合")
    @Column(name = "device_ids",columnDefinition = "TEXT")
    private String deviceIds;

    @ApiModelProperty(value = "发件单位签章id")
    private String leftSignatureId;

    @ApiModelProperty(value = "收件单位签章id")
    private String rightSignatureId;

    @ApiModelProperty(value = "区块链RID",name = "recordId")
    private String recordId;

    /**
     * 提交描述
     */
    @ApiModelProperty(value = "提交描述")
    @Column(name = "submit_description",columnDefinition = "TEXT")
    private String submitDescription;
    /**
     * 审核反馈
     */
    @ApiModelProperty(value = "审核反馈")
    @Column(name = "auditing_feedback",columnDefinition = "TEXT")
    private String auditingFeedback;

    @ApiModelProperty(value = "清退状态",name = "1.清退中，2.清退完成")
    private Integer repelStatus;

    @ApiModelProperty(value = "批复文号文件")
    @Column(name = "reply_files",columnDefinition = "TEXT")
    private String replyFiles;

    @ApiModelProperty(value = "申请文号文件")
    @Column(name = "apply_files",columnDefinition = "TEXT")
    private String applyFiles;

    @Column(name = "send_files",columnDefinition = "TEXT")
    private String sendFiles;

    @Column(name = "script_json",columnDefinition = "TEXT")
    private String scriptJson;

    @Transient
    private List<ScriptSaveVo> scripts = new ArrayList<>();



    @Transient
    private List<FileRet> sendFileList = new ArrayList<>();

    @Transient
    @ApiModelProperty(value = "批复文号文件集合")
    private List<FileRet> replyFileList = new ArrayList<>();

    @Transient
    @ApiModelProperty(value = "申请文号文件集合")
    private List<FileRet> applyFileList = new ArrayList<>();

    @Transient
    @ApiModelProperty(value = "装备List")
    private List<DeviceLibrary> deviceLibraryEntities =new ArrayList<>();

    @Transient
    @ApiModelProperty(value = "清退单对象")
    private List<FileRet> billFiles ;

    @Transient
    @ApiModelProperty(value = "清退单对象")
    private List<FileRet> inFiles ;

    @Transient
    @ApiModelProperty(value = "清退单对象")
    private List<FileRet> outboundFiles ;


    public Documents toDoc(){
        return new Documents(num,"装备清退单据",receiveUnit,replayNumber,sendUnit,null,null,senderUserA,senderUserB,receiveUserA,receiveUserB,null);
    }

}
