package com.tykj.dev.device.sendback.entity.domain;

import com.tykj.dev.device.sendback.entity.vo.ModelCount;
import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelTaskStatistical.java
 * @Description TODO
 * @createTime 2021年01月07日 09:35:00
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@ApiModel("清退统计维护")
@NoArgsConstructor
@AllArgsConstructor
public class RepelTaskStatistical extends BaseEntity {
    /**
     * 数据id
     */
    @Id
    @ApiModelProperty(value = "数据id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private  Integer id;

    /**
     * repelId
     */
    @ApiModelProperty(value = "业务id")
    private Integer repelId;
    /**
     * 父类taskId
     */
    @ApiModelProperty(value = "父类taskId")
    private Integer fatherTaskId;

    /**
     * taskId
     */
    @ApiModelProperty(value = "任务id")
    private Integer taskId;

    /**
     * 任务状态 0.等待处理  1.清退完成 2.延期 3.等待审核 4.待补全单据  5.待下级单位清退装备
     */
    @ApiModelProperty(value = "任务状态 1.正常提交 2.延期 3.等待审核 4.等待上传单据")
    private Integer taskStatus;

    /**
     * 区域名称
     */
    @ApiModelProperty(value = "区域名称")
    private String  areaName;

    /**
     * 本单位需要清退装备数量
     */
    @ApiModelProperty(value = "本单位需要清退装备数量")
    private Integer count;

    /**
     * 描述
     */
    @ApiModelProperty(value = "描述")
    @Column(name = "des",columnDefinition = "TEXT")
    private String des;

    /**
     * modelCount json转对象 不存数据库
     */
    @ApiModelProperty(value = "modelCount json转对象 不存数据库")
    @Transient
    private List<ModelCount> modelCountList;


    public RepelTaskStatistical(Integer repelId, Integer fatherTaskId, Integer taskId, Integer taskStatus, String areaName) {
        this.repelId = repelId;
        this.fatherTaskId = fatherTaskId;
        this.taskId = taskId;
        this.taskStatus = taskStatus;
        this.areaName = areaName;
    }

    public RepelTaskStatistical(Integer repelId, Integer fatherTaskId, Integer taskId, Integer taskStatus, String areaName, Integer count, String des) {
        this.repelId = repelId;
        this.fatherTaskId = fatherTaskId;
        this.taskId = taskId;
        this.taskStatus = taskStatus;
        this.areaName = areaName;
        this.count = count;
        this.des = des;
    }
}
