package com.tykj.dev.device.sendback.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.util.Date;

/**
 * <h4>Description : </h4>
 *
 * @Author czq
 * @Date 2020-08-17 17:26
 * @Version 1.0
 */
@Data
@ApiModel("清退出库表单")
public class SendBackOutFormVo {
    /**
     * 申请文号
     */
    @Column(name = "apply_number")
    @ApiModelProperty(value = "申请文号")
    private String applyNumber;
    /**
     * 批复文号
     */
    @Column(name = "replay_number")
    @ApiModelProperty(value = "批复文号")
    private String replayNumber;
    /**
     * 发件单位
     */
    @Column(name = "send_unit")
    @ApiModelProperty(value = "发件单位")
    private String sendUnit;
    /**
     * 收件单位
     */
    @Column(name = "receive_unit")
    @ApiModelProperty(value = "收件单位")
    private String receiveUnit;
    /**
     * 配发时间
     */
    @Column(name = "send_time")
    @ApiModelProperty(value = "配发时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sendTime;
    /**
     * 接收时间
     */
    @Column(name = "receive_time")
    @ApiModelProperty(value = "接收时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date receiveTime;
    /**
     * 发件方id(A岗位)
     */
    @Column(name = "send_userA_id")
    @ApiModelProperty(value = "发件方id(A岗位)")
    private String sendUserAName;
    /**
     * 发件方id(B岗位)
     */
    @Column(name = "send_userB_id")
    @ApiModelProperty(value = "发件方id(B岗位)")
    private String sendUserBName;
    /**
     * 收件方id(A岗位)
     */
    @Column(name = "receive_userA_id")
    @ApiModelProperty(value = "收件方id(A岗位)")
    private String receiveUserAName;
    /**
     * 收件方id(B岗位)
     */
    @Column(name = "receive_userB_id")
    @ApiModelProperty(value = "收件方id(B岗位)")
    private String receiveUserBName;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    private Integer page;

    private Integer size;

}
