package com.tykj.dev.device.sendback.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * <h4>Description : 待清退装备统计清单</h4>
 *
 * @Author czq
 * @Date 2020-08-15 17:13
 * @Version 1.0
 */
@Data
@ApiModel("待清退装备统计清单")
public class SendBackStatisticalVo {

    @ApiModelProperty(value = "装备名称", example = "xxx装备")
    public String name;

    @ApiModelProperty(value = "统计总数", example = "200")
    public Integer count = 0;

    @ApiModelProperty(value = "装备id集合", example = "[1,2,3]")
    private List<Integer> deviceIdList = new ArrayList<>();

    @ApiModelProperty(value = "型号", example = "BM-001")
    private String model;

    @ApiModelProperty(value = "统计省或各市待清退统计单的数量,key为各市或各单位名称")
    private HashMap<String, StatisticalVo> statistical = new HashMap<>();
}
