package com.tykj.dev.device.sendback.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * <h4>Description : </h4>
 *
 * @Author czq
 * @Date 2020-08-16 11:13
 * @Version 1.0
 *
 * {"areaToIds":{"浙江省":[30],"杭州市":[31,32,33]},
 * "header":["浙江省","杭州市"],
 * "map":{
 *      "11":{
 *          "浙江省":{
 *              "allCount":1,
 *              "deviceIdList":[30],
 *              "name":"",
 *              "status":1,
 *              "valCount":1
 *              },
 *      "型号":{
 *          "allCount":0,
 *          "deviceIdList":[],
 *          "name":"11",
 *          "status":3,
 *          "valCount":0
 *          },
 *      "总数":{
 *          "allCount":3,
 *          "deviceIdList":[],
 *          "name":"",
 *          "status":3,
 *          "valCount":0
 *          },
 *      "名称":{
 *          "allCount":0,
 *          "deviceIdList":[],
 *          "name":"11",
 *          "status":3,
 *          "valCount":0
 *          },
 *      "杭州市":{
 *          "allCount":2,
 *          "deviceIdList":[31,33],
 *          "name":"",
 *          "status":1,
 *          "valCount":2}
 *          }
 *     ,
 *     "22":{
 *      "浙江省":{
 *        "allCount":0,"deviceIdList":[],"name":"","status":3,"valCount":0},"型号":{"allCount":0,"deviceIdList":[],"name":"22","status":3,"valCount":0},"总数":{"allCount":1,"deviceIdList":[],"name":"","status":3,"valCount":0},"名称":{"allCount":0,"deviceIdList":[],"name":"22","status":3,"valCount":0},"杭州市":{"allCount":1,"deviceIdList":[32],"name":"","status":1,"valCount":1}}},"modelToIds":{"11":[30,31,33],"22":[32]},"name":"省D岗","status":1,"time":1600876800000,"unDevice":[]}
 */
@Data
@ApiModel("清退表的表头、截至日期和经办人")
public class SendBackVo {

    @ApiModelProperty(value = "经办人姓名")
    private String name;

    @ApiModelProperty(value = "截至日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date time;

    @ApiModelProperty(value = "是否可以办结")
    private Integer status;

    @ApiModelProperty(value = "清退单的表头")
    private List<String> header;

    @ApiModelProperty(value = "清退表单内容,key为型号，value为表单内容")
    private HashMap<String, HashMap<String, StatisticalVo>> map;

    @ApiModelProperty(value = "所有清退装备的id")
    private List<Integer> deviceIdList;

    @ApiModelProperty(value = "异常装备")
    private List<DeviceLibrary> unDevice;

    @ApiModelProperty(value = "异常装备描述")
    private UnDeviceDesVo unDeviceDes;

    @ApiModelProperty(value = "区域和任务id")
    private HashMap<String, Integer> areaToTaskId;

    @ApiModelProperty(value = "前段取值")
    private List<HashMap<String, StatisticalVo>> dataList;

    @ApiModelProperty(value = "查看某个区域")
    private HashMap<String, List<Integer>> areaToIds;

    @ApiModelProperty(value = "查看某个模板")
    private HashMap<String, List<Integer>> modelToIds;

}
