package com.tykj.dev.device.sendback.repository;

import com.tykj.dev.device.sendback.entity.domain.DeviceRepelDetail;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.Date;
import java.util.List;

public interface DeviceRepelDetailDao extends JpaRepository<DeviceRepelDetail, Integer>, JpaSpecificationExecutor<DeviceRepelDetail> {
 List<DeviceRepelDetail> findAllBySendTimeBetweenAndSendUnitIdAndRepelStatus(Date time,Date endTime, Integer unitId, Integer repelStatus);

 @Query(value = "select d from DeviceRepelDetail as d where d.sendUnitId= ?1 or d.receiveUnitId = ?1")
 List<DeviceRepelDetail> findAllBySendUnitIdOrReceiveUnitId(Integer unitId);

 List<DeviceRepelDetail> findAllByReceiveUnitIdIn(List<Integer> ids);
}
