package com.tykj.dev.device.sendback.service.impl;

import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.sendback.entity.domain.DeviceRepelDetail;
import com.tykj.dev.device.sendback.repository.DeviceRepelDetailDao;
import com.tykj.dev.device.sendback.service.DeviceRepelDetailService;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceRepelDetailServiceImpl.java
 * @Description TODO
 * @createTime 2021年01月07日 09:52:00
 */
@Service
@Slf4j
public class DeviceRepelDetailServiceImpl implements DeviceRepelDetailService {
    @Autowired
    DeviceRepelDetailDao deviceRepelDetailDao;

    @Autowired
    DeviceLibraryDao deviceLibraryDao;


    @Override
    public DeviceRepelDetail saveDeviceRepelDetail(DeviceRepelDetail deviceRepelDetail) {
        log.info("[清退] 详情添加成功");
        return deviceRepelDetailDao.save(deviceRepelDetail);
    }

    @Override
    public DeviceRepelDetail findDeviceRepelDetail(Integer repelDetailId) {
        Optional<DeviceRepelDetail> optional = deviceRepelDetailDao.findById(repelDetailId);
        if (optional.isPresent()){
            DeviceRepelDetail deviceRepelDetail=optional.get();
            deviceRepelDetail.setDeviceLibraryEntities(findInvoleDevice(deviceRepelDetail.getDeviceIds()));
            deviceRepelDetail.setBillFiles(FilesUtil.stringFileToList(deviceRepelDetail.getBillFile()));
            deviceRepelDetail.setOutboundFiles(FilesUtil.stringFileToList(deviceRepelDetail.getOutboundFile()));
            deviceRepelDetail.setInFiles(FilesUtil.stringFileToList(deviceRepelDetail.getInFile()));
            return deviceRepelDetail;
        }else {
            log.info("[清退] 详情查看错误，id没有找到{}",repelDetailId);
            throw new ApiException(ResponseEntity.status(500).body("清退详情id没有找到:"+repelDetailId));
        }
    }

    @Override
    public DeviceRepelDetail findDeviceRepelDetailNoDev(Integer repelDetailId) {
        Optional<DeviceRepelDetail> optional = deviceRepelDetailDao.findById(repelDetailId);
        if (optional.isPresent()){
            return optional.get();
        }else {
            log.info("[清退] 详情查看错误，id没有找到{}",repelDetailId);
            throw new ApiException(ResponseEntity.status(500).body("清退详情id没有找到:"+repelDetailId));
        }
    }

    @Override
    public List<DeviceRepelDetail> findAll() {
        return deviceRepelDetailDao.findAll();
    }

    @Override
    public List<Integer> findYearAndUnitToDeviceList(Date time,Date endTime,Integer unitId) {
        Set<Integer> libraries=new HashSet<>();
        deviceRepelDetailDao.findAllBySendTimeBetweenAndSendUnitIdAndRepelStatus(time,endTime,unitId,2).forEach(
           deviceRepelDetail -> libraries.addAll(StringUtils.stringToList(deviceRepelDetail.getDeviceIds()))
        );
        return new ArrayList<>(libraries);
    }

    @Override
    public List<DeviceRepelDetail> findUnitIdSendOrReceive(Integer unitId) {
        return deviceRepelDetailDao.findAllBySendUnitIdOrReceiveUnitId(unitId);
    }

    @Override
    public List<DeviceRepelDetail> findIdsReceiptUnits(List<Integer> unitIds) {
        return deviceRepelDetailDao.findAllByReceiveUnitIdIn(unitIds);
    }


    private List<DeviceLibrary> findInvoleDevice(String involeDevice){
        if (involeDevice!=null && !involeDevice.equals(",") ) {
        List<String> idStringList = Arrays.asList(involeDevice.split(","));
        List<String> idListString = idStringList.stream().filter(list2->!list2.equals("")).collect(Collectors.toList());
        System.out.println(idListString);
        List<Integer> devIds = idListString.stream().map(Integer::parseInt).collect(Collectors.toList());
        return deviceLibraryDao.getDeviceLibraryEntitiesByIdIn(devIds).stream().map(DeviceLibrary::setConfigName).collect(Collectors.toList());
        }else {
            return new ArrayList<>();
        }
        }
}
