package com.tykj.dev.device.sendback.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.device.sendback.entity.domain.DeviceRepel;
import com.tykj.dev.device.sendback.entity.domain.DeviceRepelDetail;
import com.tykj.dev.device.sendback.entity.vo.*;
import com.tykj.dev.device.sendback.service.*;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.service.UnitsService;
import com.tykj.dev.misc.base.BusinessEnum;
import com.tykj.dev.misc.base.DeviceLifeStatus;
import com.tykj.dev.misc.base.StatusEnum;
import com.tykj.dev.misc.utils.DeviceSeqUtil;
import com.tykj.dev.misc.utils.JacksonUtil;
import com.tykj.dev.misc.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.Transient;
import java.lang.reflect.Field;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelQueryServiceImpl.java
 * @Description 清退查询接口服务
 * @createTime 2021年01月10日 15:30:00
 */
@Service
@Slf4j
public class RepelQueryServiceImpl implements RepelQueryService {
    @Autowired
    RepelTaskStatisticalService repelTaskStatisticalService;
    @Autowired
    DeviceRepelDetailService repelDetailService;
    @Autowired
    TaskService taskService;
    @Autowired
    DeviceRepelService deviceRepelService;
    @Autowired
    DeviceLibraryDao deviceLibraryDao;
    @Autowired
    UnitsService unitsService;
    @Autowired
    RepelDeviceUnitService deviceUnitService;

    @Override
    public RepelStatisticsVo findRepelTaskStatisticals(Integer taskId, Integer billId) {
       DeviceRepel deviceRepel=deviceRepelService.findDeviceRepel(billId);
       return new RepelStatisticsVo(deviceRepel.getInitiateName(),deviceRepel.getTime(),repelTaskStatisticalService.findAllRepelTaskStatistical(taskId,billId));
    }

    @Override
    public DeviceRepelDetail findDeviceRepelDetail(Integer taskId) {
         TaskBto taskBto= taskService.get(taskId);
        DeviceRepelDetail deviceRepelDetail=  repelDetailService.findDeviceRepelDetail(taskBto.getBillId());
        if (deviceRepelDetail.getScriptJson()!=null) {
            deviceRepelDetail.setScripts(JacksonUtil.readValue(deviceRepelDetail.getScriptJson(), new TypeReference<List<ScriptSaveVo>>() {
            }));
        }
        return deviceRepelDetail;
    }

    @Override
    public DeviceRepel findDeviceRepel(Integer taskId) {
        TaskBto taskBto= taskService.get(taskId);
        if (taskBto.getBusinessType()== BusinessEnum.SEND_BACK_STATISTICAL.id){
            return deviceRepelService.findDeviceRepel(taskBto.getBillId());
        }
        DeviceRepelDetail deviceRepelDetail = repelDetailService.findDeviceRepelDetailNoDev(taskBto.getBillId());
        return deviceRepelService.findDeviceRepel(deviceRepelDetail.getRepelId());
    }

    @Override
    public  DeviceChooseRepel findDeviceChooseRepel(List<Integer> fielding, Integer unitId,Integer taskId) {
        List<DeviceLibrary> deviceLibraries=new ArrayList<>();
        List<DeviceLibrary> deviceLibrariesAbnormal=new ArrayList<>();
        Units units= unitsService.findById(unitId);

        DeviceRepelDetail deviceRepelDetail= repelDetailService.findDeviceRepelDetail(taskService.get(taskId).getBillId());
        DeviceRepel deviceRepel=deviceRepelService.findDeviceRepel(deviceRepelDetail.getRepelId());
        if (deviceRepel.getType()==0) {
            deviceLibraryDao.findAllByPackingIdInAndOwnUnit(fielding, units.getName()).stream()
                    .filter(deviceLibrary -> deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.IN_LIBRARY.id)
                            || deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.REPEL.id)
                            || deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.SEND_BACK.id)
                            || deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.REPAIRING.id)
                            || deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.IN_TRANSIT.id)
                            || deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.USE.id))
                    .map(DeviceLibrary::setConfigName).forEach(
                    deviceLibrary -> {
                        if (deviceLibrary.getOwnUnit().equals(deviceLibrary.getLocationUnit())) {
                            if (deviceLibrary.getLifeStatus() == 2 || deviceLibrary.getLifeStatus() == 15 || deviceLibrary.getLifeStatus() == 14 || deviceLibrary.getLifeStatus() == 6) {
                                deviceLibraries.add(deviceLibrary);
                            } else {
                                deviceLibrariesAbnormal.add(deviceLibrary);
                            }
                        } else {
                            deviceLibrariesAbnormal.add(deviceLibrary);
                        }
                    }
            );
        }else {
            deviceLibraryDao.findAllBySeqNumberIn(DeviceSeqUtil.selectDeviceSeqs(deviceRepel.getSeqNumbers())).stream()
                    .filter(deviceLibrary -> deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.IN_LIBRARY.id)
                            || deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.REPEL.id)
                            || deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.SEND_BACK.id)
                            || deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.REPAIRING.id)
                            || deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.IN_TRANSIT.id)
                            || deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.USE.id))
                    .filter(deviceLibrary -> deviceLibrary.getOwnUnit().equals(units.getName()))
                    .map(DeviceLibrary::setConfigName).forEach(
                    deviceLibrary -> {
                        if (deviceLibrary.getOwnUnit().equals(deviceLibrary.getLocationUnit())) {
                            if (deviceLibrary.getLifeStatus() == 2 || deviceLibrary.getLifeStatus() == 15 || deviceLibrary.getLifeStatus() == 14 || deviceLibrary.getLifeStatus() == 6) {
                                deviceLibraries.add(deviceLibrary);
                            } else {
                                deviceLibrariesAbnormal.add(deviceLibrary);
                            }
                        } else {
                            deviceLibrariesAbnormal.add(deviceLibrary);
                        }
                    }
            );
        }
        int isNotSub = 1;
        if (units.getLevel()==2) {
            TaskBto taskBto = taskService.findFatherIdAndCustomInfo(taskId);
            if (!taskBto.getBillStatus().equals(StatusEnum.END.id)) {
                isNotSub = 0;
            }
        }
        return new DeviceChooseRepel(deviceLibraries,deviceLibrariesAbnormal,isNotSub);
    }

    @Override
    public List<DeviceLibrary> findDeviceSendOut(Integer taskId) {
        TaskBto taskBto = taskService.get(taskId);
        DeviceRepelDetail deviceRepelDetail= repelDetailService.findDeviceRepelDetail(taskBto.getBillId());
        return findInvoleDevice(deviceRepelDetail.getDeviceIds());
    }

    @Override
    public List<ModelNameGroup> toRepelList(RepelManagementVo repelManagementVo) {
        Units units=  unitsService.findById(repelManagementVo.getUnitId());
        return toModelNameGroup(deviceLibraryDao.findAllByOwnUnitAndLocationUnitAndLifeStatus(units.getName(),units.getName(),DeviceLifeStatus.REPEL.id).stream().map(DeviceLibrary::setConfigName).filter(deviceLibrary ->deviceLibrary.getUpdateTime()==null ||(deviceLibrary.getUpdateTime().getTime()>=repelManagementVo.getTime()&&deviceLibrary.getUpdateTime().getTime()<=repelManagementVo.getEndTime())).collect(Collectors.toList()));
    }

    @Override
    public List<DeviceLibrary> toRepelListDev(RepelManagementVo repelManagementVo) {
        return null;
    }

    private List<ModelNameGroup> toModelNameGroup(List<DeviceLibrary> deviceLibraries){
        Map<String,ModelNameGroup> modelNameGroupMap=new HashMap<>();
        deviceLibraries.forEach(
                deviceLibrary -> {
                    List<Integer> ids=new ArrayList<>();
                    String key=deviceLibrary.getModel()+deviceLibrary.getName();
                    if (!modelNameGroupMap.containsKey(key)){
                        ids.add(deviceLibrary.getId());
                        modelNameGroupMap.put(key,new ModelNameGroup(deviceLibrary.getModel(),deviceLibrary.getName(),ids));
                    }else {
                        ModelNameGroup modelNameGroup=modelNameGroupMap.get(key);
                        ids=modelNameGroupMap.get(key).getIds();
                        ids.add(deviceLibrary.getId());
                        modelNameGroup.setIds(ids);
                        modelNameGroupMap.put(key,modelNameGroup);
                    }
                }
        );
        return modelNameGroupMap.values().stream().sorted(Comparator.comparing(ModelNameGroup::getModel)).collect(Collectors.toList());
    }

    @Override
    public List<DevRepelVo> findRepelListModelNameGroup(ModelAndTypeVo modelAndTypeVo) {
        Units units=  unitsService.findById(modelAndTypeVo.getUnitId());
        if (modelAndTypeVo.getModel()==null&&modelAndTypeVo.getType()==null){
          return deviceLibraryDao.findAllByOwnUnitAndLocationUnitAndLifeStatus(units.getName(),units.getName(),15).stream().map(DeviceLibrary::setConfigName)
                  .map(this::devRepelVo).collect(Collectors.toList());
        }else if (modelAndTypeVo.getModel()!=null&&modelAndTypeVo.getType()==null){
            return deviceLibraryDao.findAllByOwnUnitAndLocationUnitAndLifeStatus(units.getName(),units.getName(),15).stream().filter(deviceLibrary -> deviceLibrary.getModel().equals(modelAndTypeVo.getModel())).map(DeviceLibrary::setConfigName)
                    .map(this::devRepelVo).collect(Collectors.toList());
        }else if (modelAndTypeVo.getModel()==null&&modelAndTypeVo.getType()!=null){
            return deviceLibraryDao.findAllByOwnUnitAndLocationUnitAndLifeStatus(units.getName(),units.getName(),15).stream().map(DeviceLibrary::setConfigName)
                    .filter(deviceLibrary -> deviceLibrary.getType().equals(modelAndTypeVo.getType()))
//                    .filter(deviceLibrary -> deviceLibrary.getModel()==null|| deviceLibrary.getModel().equals(modelAndTypeVo.getModel()))
                    .map(this::devRepelVo).collect(Collectors.toList());
        }else {
          return  deviceLibraryDao.findAllByOwnUnitAndLocationUnitAndLifeStatus(units.getName(),units.getName(),15).stream().filter(deviceLibrary -> deviceLibrary.getModel().equals(modelAndTypeVo.getModel())).map(DeviceLibrary::setConfigName)
                    .filter(deviceLibrary -> deviceLibrary.getType().equals(modelAndTypeVo.getType()))
                   .map(this::devRepelVo).collect(Collectors.toList());
        }
    }



    @Override
    public  List<ModelNameGroup> clearedList(RepelManagementVo repelManagementVo) {
         new Date(repelManagementVo.getTime());
//        return toModelNameGroup(repelDetailService.findYearAndUnitToDeviceList(new Date(repelManagementVo.getTime()),new Date(repelManagementVo.getEndTime()),repelManagementVo.getUnitId()));
    return new ArrayList<>();
    }

    @Override
    public List<ModelNameGroup> retiredList(RepelManagementVo repelManagementVo) {
//        Units units=  unitsService.findById(repelManagementVo.getUnitId());

        return toModelNameGroup(deviceLibraryDao.findAllByLifeStatus(DeviceLifeStatus.RETIRE.id).stream().filter(deviceLibrary ->deviceLibrary.getUpdateTime()==null ||(deviceLibrary.getUpdateTime().getTime()>=repelManagementVo.getTime()&&deviceLibrary.getUpdateTime().getTime()<=repelManagementVo.getEndTime())).collect(Collectors.toList()));

    }

    @Override
    public List<DeviceLibrary> provinceDirectlyUnderDev(Integer taskId) {
        TaskBto taskBto= taskService.get(taskId);
        DeviceRepelDetail deviceRepelDetail=repelDetailService.findDeviceRepelDetailNoDev(taskBto.getBillId());
        DeviceRepel deviceRepel=deviceRepelService.findDeviceRepel(deviceRepelDetail.getRepelId());
        List<String> unitNames=unitsService.finAllDirectlUnderUnits().stream().map(Units::getName).collect(Collectors.toList());
        return deviceLibraryDao.findAllByPackingIdInAndOwnUnitIn(StringUtils.stringToList(deviceRepel.getFielding()),unitNames).stream().map(DeviceLibrary::setConfigName).collect(Collectors.toList());
    }


    @Override
    public List<DirectlyUnderNavigation> directlyUnderUnitLeftNavigation(Integer taskId) {
        TaskBto taskBto= taskService.get(taskId);
        List<DirectlyUnderNavigation> list=new ArrayList<>();
        DeviceRepelDetail deviceRepelDetail=repelDetailService.findDeviceRepelDetailNoDev(taskBto.getBillId());
        DeviceRepel deviceRepel=deviceRepelService.findDeviceRepel(deviceRepelDetail.getRepelId());
        unitsService.findAllByIdIn(StringUtils.stringToList(deviceRepel.getTaskScope())).forEach(
                units -> {
                    if (units.getType()==2){
                        list.add(new DirectlyUnderNavigation(units.getUnitId(),units.getName(), UUID.randomUUID().toString()));
                    }
                }
        );
        return list;
    }

    @Override
    public List<DeviceLibrary> provinceDirectlyUnderSelectedDev(Integer taskId, Integer unitId) {
        Units units=unitsService.findById(unitId);
        TaskBto taskBto= taskService.get(taskId);
        DeviceRepelDetail deviceRepelDetail= repelDetailService.findDeviceRepelDetail(taskBto.getBillId());
        return  findInvoleDevice(deviceRepelDetail.getDeviceIds()).stream().filter(deviceLibrary -> deviceLibrary.getOwnUnit().equals(units.getName())).collect(Collectors.toList());
    }

    @Override
    public List<DevRepelVo> repelManagementListDetails(List<Integer> ids) {
        return deviceLibraryDao.findAllById(ids).stream().map(DeviceLibrary::setConfigName).map(this::devRepelVo).collect(Collectors.toList());
    }

    @Override
    public List<DeviceRepelDetail> getList(SecurityUser securityUser) {
        List<DeviceRepelDetail> list=new ArrayList<>();

        List<DeviceRepelDetail> deviceRepelDetails=new ArrayList<>();
        Units units=securityUser.getCurrentUserInfo().getUnits();
        if (securityUser.getCurrentUserInfo().getUnits().getLevel()!=1){
            deviceRepelDetails=repelDetailService.findUnitIdSendOrReceive(units.getUnitId());
        }else {
            deviceRepelDetails=repelDetailService.findAll();
        }

        deviceRepelDetails.stream().filter(i-> i.getRepelStatus()!=null&&i.getRepelStatus()==2).forEach(
                deviceRepelDetail -> {
                    if (deviceRepelDetail.getBillFile()!=null){
                        deviceRepelDetail.setBillFiles(FilesUtil.stringFileToList(deviceRepelDetail.getBillFile()));
                    }
                    if (deviceRepelDetail.getOutboundFile()!=null){
                        deviceRepelDetail.setOutboundFiles(FilesUtil.stringFileToList(deviceRepelDetail.getOutboundFile()));
                    }
                    deviceRepelDetail.setScripts(JacksonUtil.readValue(deviceRepelDetail.getScriptJson(), new TypeReference<List<ScriptSaveVo>>() {}));
                    deviceRepelDetail.setDeviceLibraryEntities(deviceLibraryDao.findAllById(StringUtils.stringToList(deviceRepelDetail.getDeviceIds())).stream().map(DeviceLibrary::setConfigName).collect(Collectors.toList()));
                    list.add(deviceRepelDetail);
                }
        );
        return list;
    }


    @Override
    public DeviceChooseRepel findDeviceChooseRepel1(List<Integer> fielding, Integer unitId) {
        List<DeviceLibrary> deviceLibraries=new ArrayList<>();
        List<DeviceLibrary> deviceLibrariesAbnormal=new ArrayList<>();
        Units units= unitsService.findById(unitId);
        deviceLibraryDao.findAllByPackingIdInAndOwnUnit(fielding,units.getName()).stream()
                .filter(deviceLibrary -> deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.IN_LIBRARY.id)
                        ||deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.REPAIRING.id)
                        ||deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.IN_TRANSIT.id)
                        ||deviceLibrary.getLifeStatus().equals(DeviceLifeStatus.USE.id))
                .map(DeviceLibrary::setConfigName).forEach(
                deviceLibrary -> {
                    if (deviceLibrary.getOwnUnit().equals(deviceLibrary.getLocationUnit())){
                        if (deviceLibrary.getLifeStatus()==2 ||deviceLibrary.getLifeStatus()==14) {
                            deviceLibraries.add(deviceLibrary);
                        }else {
                            deviceLibrariesAbnormal.add(deviceLibrary);
                        }
                    }else {
                        deviceLibrariesAbnormal.add(deviceLibrary);
                    }
                }
        );
        return new DeviceChooseRepel(deviceLibraries,deviceLibrariesAbnormal,1);
    }

    private DevRepelVo devRepelVo(DeviceLibrary deviceLibrary){
        return new DevRepelVo(deviceLibrary.getId(),deviceLibrary.getName(),deviceLibrary.getModel(),deviceLibrary.getSeqNumber(),deviceLibrary.getType(),deviceLibrary.getTypeName(),deviceLibrary.getUpdateTime());

    }


    /**
     * 查询已清退装备列表
     */
    @Override
    public PagingVo clearedDeviceList(RepelManagementVo repelManagementVo) {
        Page<DeviceLibrary> page=deviceLibraryDao.findAll(getClearedSpecification(repelManagementVo),repelManagementVo.getPageable());
        return PagingVo.builder()
                .data(page.getContent().stream().map(DeviceLibrary::setConfigName).collect(Collectors.toList())).page(repelManagementVo.getPage())
                .size(repelManagementVo.getSize()).total((int)page.getTotalElements()).build();
    }

    @Override
    public PagingVo repelDeviceList(RepelManagementVo repelManagementVo) {
        Page<DeviceLibrary> page=deviceLibraryDao.findAll(getRepelDeviceSpecification(repelManagementVo),repelManagementVo.getPageable());
        return PagingVo.builder()
                .data(page.getContent().stream().map(DeviceLibrary::setConfigName).collect(Collectors.toList())).page(repelManagementVo.getPage())
                .size(repelManagementVo.getSize()).total((int)page.getTotalElements()).build();
    }

    private Specification<DeviceLibrary> getRepelDeviceSpecification(RepelManagementVo repelManagementVo) {
        PredicateBuilder<DeviceLibrary> predicateBuilder = getPredicateBuilder(repelManagementVo);
        //unitId为空，默认查询当前单位
        predicateBuilder.eq("lifeStatus", com.tykj.dev.config.base.DeviceLifeStatus.SEND_BACK);
        return predicateBuilder.build();

    }

    private Specification<DeviceLibrary> getClearedSpecification(RepelManagementVo repelManagementVo) {
        PredicateBuilder<DeviceLibrary> predicateBuilder = getPredicateBuilder(repelManagementVo);
        //unitId为空，默认查询当前单位
        predicateBuilder.in("id",repelDetailService.findYearAndUnitToDeviceList(new Date(repelManagementVo.getTime()),new Date(repelManagementVo.getEndTime()),repelManagementVo.getUnitId()));
        return predicateBuilder.build();

    }

    private PredicateBuilder<DeviceLibrary> getPredicateBuilder(RepelManagementVo repelManagementVo) {
        PredicateBuilder<DeviceLibrary> predicateBuilder = Specifications.and();
        if (repelManagementVo != null) {
            if (repelManagementVo.getModel() != null) {
                predicateBuilder.eq("model", repelManagementVo.getModel());
            }
            if (repelManagementVo.getName() != null) {
                predicateBuilder.eq("name", repelManagementVo.getName());
            }
            if (repelManagementVo.getSecretLevel() != null) {
                predicateBuilder.eq("secretLevel", repelManagementVo.getSecretLevel());
            }
            if (repelManagementVo.getMatchingRange() != null) {
                predicateBuilder.eq("matchingRange", repelManagementVo.getMatchingRange());
            }
            if (repelManagementVo.getStorageType() != null) {
                predicateBuilder.eq("storageType", repelManagementVo.getStorageType());
            }
            if (repelManagementVo.getManageStatus() != null) {
                predicateBuilder.eq("manageStatus", repelManagementVo.getManageStatus());
            }
            if (repelManagementVo.getInvisibleRange() != null) {
                predicateBuilder.eq("invisibleRange", repelManagementVo.getInvisibleRange());
            }
            if (repelManagementVo.getTime()!=null){
                predicateBuilder.gt("updateTime",new Date(repelManagementVo.getTime()));
            }
            if (repelManagementVo.getEndTime()!=null){
                predicateBuilder.lt("updateTime",new Date(repelManagementVo.getEndTime()));
            }
            if (repelManagementVo.getContent() != null) {
                Class<DeviceLibrary> deviceLibraryEntity = DeviceLibrary.class;
                Field[] declaredFields = deviceLibraryEntity.getDeclaredFields();
                PredicateBuilder<DeviceLibrary> p = Specifications.or();
                for (Field field : declaredFields) {
                    if (field.getType().equals(String.class) && field.getAnnotation(Transient.class) == null) {
                        p.like(field.getName(), "%" + repelManagementVo.getContent() + "%");
                    }
                }
                predicateBuilder.predicate(p.build());
            }
        }
        return predicateBuilder;
    }

    private List<DeviceLibrary> findInvoleDevice(String involeDevice){
        if (involeDevice!=null && !involeDevice.equals("")&& !involeDevice.equals(",")) {
            List<String> idStringList = Arrays.asList(involeDevice.split(","));
            List<String> idListString = idStringList.stream().filter(list2->!list2.equals("")).collect(Collectors.toList());
            System.out.println(idListString);
            List<Integer> devIds = idListString.stream().map(Integer::parseInt).collect(Collectors.toList());
            return deviceLibraryDao.getDeviceLibraryEntitiesByIdIn(devIds).stream().map(DeviceLibrary::setConfigName).collect(Collectors.toList());
        }else {
            return new ArrayList<>();
        }
    }
}
