package com.tykj.dev.device.sendback.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tykj.dev.device.sendback.entity.domain.RepelTaskStatistical;
import com.tykj.dev.device.sendback.entity.vo.ModelCount;
import com.tykj.dev.device.sendback.repository.RepelTaskStatisticalDao;
import com.tykj.dev.device.sendback.service.RepelTaskStatisticalService;
import com.tykj.dev.misc.utils.JacksonUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelTaskStatisticalServiceImpl.java
 * @Description TODO
 * @createTime 2021年01月07日 09:53:00
 */
@Service
@Slf4j
public class RepelTaskStatisticalServiceImpl implements RepelTaskStatisticalService {
    @Autowired
    RepelTaskStatisticalDao repelTaskStatisticalDao;

    @Override
    public RepelTaskStatistical saveRepelTaskStatistical(RepelTaskStatistical repelTaskStatistical) {
        return repelTaskStatisticalDao.save(repelTaskStatistical);
    }

    @Override
    public List<RepelTaskStatistical> findAllRepelTaskStatistical(Integer fatherTaskId, Integer repelId) {
        return repelTaskStatisticalDao.findAllByFatherTaskIdAndAndRepelId(fatherTaskId,repelId);
    }


    @Override
    public void saveAllRepelTaskStatistical(List<RepelTaskStatistical> repelTaskStatisticalList) {
        repelTaskStatisticalDao.saveAll(repelTaskStatisticalList);
    }


    @Override
    public RepelTaskStatistical findRepelTaskStatistical(Integer taskId, Integer repelId) {
        return repelTaskStatisticalDao.findByTaskIdAndAndRepelId(taskId, repelId);
    }
}
