package com.tykj.dev.statistical.cache;

import com.tykj.dev.statistical.vo.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author dengdiyi
 * 大屏缓存
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class BigScreenCache {

    /**
     * 省及各市装备统计信息
     */
    private List<DevNum> devNums;

    /**
     * 全省入库业务每月数量统计
     */
    private List<BusinessNum> businessNums;

    /**
     * 大屏中心信息统计
     */
    private CenterNum centerNum;

    /**
     * 装备维修情况数量统计
     */
    private RepairNum repairNum;

    /**
     * 装备维修情况装备统计
     */
    private List<RepairDevice> repairDevices;

    /**
     * 最近一次自查统计
     */
    private List<SelfCheckNum> selfCheckNums;

    /**
     * 专管员统计
     */
    private List<UserDateScreen> userDateScreens;
}
