package com.tykj.dev.statistical.cache;

import com.tykj.dev.statistical.service.BigScreenService;
import com.tykj.dev.statistical.service.StatisticalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.text.ParseException;

/**
 * @author dengdiyi
 * 统计分析缓存配置类
 */
@Configuration
public class CacheConfig {

    @Autowired
    private StatisticalService statisticalService;

    @Autowired
    private BigScreenService bigScreenService;

    @Bean
    public StatisticalCache initStatisticalCache() throws ParseException {
        return new StatisticalCache(statisticalService.getDeviceNum(),statisticalService.getLifeStatus(1),statisticalService.getLifeStatus(2),statisticalService.getSelfCheck(),statisticalService.getYearSelfCheck(),statisticalService.getRfidWarning(),statisticalService.getRfidWarningDetail(1),statisticalService.getRfidWarningDetail(2),statisticalService.getCheckNum(),statisticalService.getConfirmCheck(1),statisticalService.getConfirmCheck(2),statisticalService.getUserGeneralSituation(),statisticalService.getSelfCheckStat());
    }

    @Bean
    public BigScreenCache initBigScreenCache(){
        return new BigScreenCache(bigScreenService.getAllDeviceNum(),bigScreenService.getBusinessNum(2),bigScreenService.getCenterNum(),bigScreenService.getRepairNum(),bigScreenService.getRepairDevices(),bigScreenService.getSelfCheckNum(),bigScreenService.selectUserDataScreen());
    }
}
