package com.tykj.dev.statistical.cache;

import com.tykj.dev.config.TaskBeanConfig;
import com.tykj.dev.device.user.cache.AreaCache;
import com.tykj.dev.device.user.cache.UnitsCache;
import com.tykj.dev.device.user.cache.UserCache;
import com.tykj.dev.device.user.subject.dao.AreaDao;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.dao.UserDao;
import com.tykj.dev.device.user.subject.entity.Area;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.statistical.service.BigScreenService;
import com.tykj.dev.statistical.service.StatisticalService;
import lombok.Data;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.concurrent.ScheduledFuture;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author dengdiyi
 * 缓存更新定时任务
 */
@Slf4j
@Component
@EnableAsync
@Data
public class CacheRefreshTask {

    /**
     * 每十分钟
     */
    private String cron = "0 0/10 * * * ?";

    private ScheduledFuture scheduledFuture;

    final StatisticalService statisticalService;

    final AreaDao areaDao;

    final UserDao userDao;

    final UnitsDao unitsDao;

    final StatisticalCache statisticalCache;

    final AreaCache areaCache;

    final UserCache userCache;

    final UnitsCache unitsCache;

    final BigScreenCache bigScreenCache;

    final BigScreenService bigScreenService;

    public CacheRefreshTask(StatisticalService statisticalService,AreaDao areaDao,UserDao userDao,UnitsDao unitsDao,StatisticalCache statisticalCache,AreaCache areaCache,UserCache userCache,UnitsCache unitsCache,BigScreenCache bigScreenCache,BigScreenService bigScreenService){
        this.statisticalService = statisticalService;
        this.areaDao = areaDao;
        this.userDao = userDao;
        this.unitsDao = unitsDao;
        this.areaCache = areaCache;
        this.userCache = userCache;
        this.unitsCache = unitsCache;
        this.statisticalCache = statisticalCache;
        this.bigScreenCache = bigScreenCache;
        this.bigScreenService = bigScreenService;
        scheduledFuture = TaskBeanConfig.getThreadPoolTaskScheduler().schedule(new RefreshTask(), triggerContext -> new CronTrigger(cron).nextExecutionTime(triggerContext));
        log.info("[统计分析模块]:定时更新缓存任务开启");
    }

    public class RefreshTask implements Runnable {
        @SneakyThrows
        @Override
        @Transactional(rollbackFor = Exception.class)
        public void run() {
            if (areaCache!=null&&areaDao!=null){
                areaCache.setIdMap(areaDao.findAll().stream().collect(Collectors.toMap(Area::getId, Function.identity())));
                areaCache.setNameMap(areaDao.findAll().stream().collect(Collectors.toMap(Area::getName, Function.identity())));
                log.info("[统计分析模块]:更新区域缓存");
            }
            if (userCache!=null&&userDao!=null){
                userCache.setIdMap(userDao.findAll().stream().collect(Collectors.toMap(User::getUserId, Function.identity())));
                log.info("[统计分析模块]:更新用户缓存");
            }
            if (unitsCache!=null&&unitsDao!=null){
                unitsCache.setIdMap(unitsDao.findAll().stream().collect(Collectors.toMap(Units::getUnitId, Function.identity())));
                log.info("[统计分析模块]:更新单位缓存");
            }
            if (statisticalService!=null&&statisticalCache!=null){
                statisticalCache.setAlarmSituation(statisticalService.getRfidWarning());
                statisticalCache.setChecks(statisticalService.getCheckNum());
                statisticalCache.setCityDevLifeSectors(statisticalService.getLifeStatus(2));
                statisticalCache.setProvinceDevLifeSectors(statisticalService.getLifeStatus(1));
                statisticalCache.setDevNums(statisticalService.getDeviceNum());
                statisticalCache.setQuarterAlarmSituations(statisticalService.getRfidWarningDetail(1));
                statisticalCache.setYearAlarmSituations(statisticalService.getRfidWarningDetail(2));
                statisticalCache.setSelfInspections(statisticalService.getSelfCheck());
                statisticalCache.setUserGeneralSituation(statisticalService.getUserGeneralSituation());
                statisticalCache.setFirstYearVerifications(statisticalService.getConfirmCheck(1));
                statisticalCache.setLastYearVerifications(statisticalService.getConfirmCheck(2));
                statisticalCache.setYearSelfInspections(statisticalService.getYearSelfCheck());
                statisticalCache.setSelfCheckVos(statisticalService.getSelfCheckStat());
                log.info("[统计分析模块]:更新统计分析缓存");
            }
            if (bigScreenService!=null&&bigScreenCache!=null){
                bigScreenCache.setBusinessNums(bigScreenService.getBusinessNum(2));
                bigScreenCache.setCenterNum(bigScreenService.getCenterNum());
                bigScreenCache.setDevNums(bigScreenService.getAllDeviceNum());
                bigScreenCache.setRepairDevices(bigScreenService.getRepairDevices());
                bigScreenCache.setRepairNum(bigScreenService.getRepairNum());
                bigScreenCache.setSelfCheckNums(bigScreenService.getSelfCheckNum());
                bigScreenCache.setUserDateScreens(bigScreenService.selectUserDataScreen());
                log.info("[统计分析模块]:更新大屏缓存");
            }
        }
    }
}
