package com.tykj.dev.statistical.cache;

import com.tykj.dev.statistical.vo.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author dengdiyi
 * 统计分析缓存
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class StatisticalCache {


    /**
     * 装备统计信息
     */
    private List<DevNum> devNums;

    /**
     * 省装备生命状态统计信息
     */
    private List<DevLifeSector> provinceDevLifeSectors;

    /**
     * 各市装备生命状态统计信息
     */
    private List<DevLifeSector> cityDevLifeSectors;

    /**
     * 季度自查统计信息
     */
    private List<SelfInspection> selfInspections;

    /**
     * 年度自查统计信息
     */
    private List<YearSelfInspection> yearSelfInspections;

    /**
     * 年度告警统计信息
     */
    private AlarmSituation alarmSituation;

    /**
     * 本季度各市告警统计信息
     */
    private List<AlarmSituation> quarterAlarmSituations;

    /**
     * 本年各市告警统计信息
     */
    private List<AlarmSituation> yearAlarmSituations;

    /**
     * 各市最近一次自查和核查装备数量
     */
    private List<Check> checks;

    /**
     * 上半年核查统计信息
     */
    private List<Verification> firstYearVerifications;

    /**
     * 下半年核查统计信息
     */
    private List<Verification> lastYearVerifications;

    /**
     * 专管员概要信息统计
     */
    private UserGeneralSituation userGeneralSituation;

    /**
     * 各市最近一次自查情况
     */
    private List<SelfCheckVo> selfCheckVos;

}
