package com.tykj.dev.statistical.service;

import com.tykj.dev.statistical.vo.*;

import java.text.ParseException;
import java.util.List;

/**
 * @author dengdiyi
 */
public interface StatisticalService {

    /**
     * 获取装备统计信息
     */
    List<DevNum> getDeviceNum();

    /**
     * @param type 类型（1：省，2：市）
     * 获取装备生命状态统计信息
     */
    List<DevLifeSector> getLifeStatus(Integer type);

    /**
     * 获取季度自查统计信息
     */
    List<SelfInspection> getSelfCheck();

    /**
     * 获取各市最近一次自查完成情况
     */
    List<SelfCheckVo> getSelfCheckStat();

    /**
     * 获取年度自查统计信息
     */
    List<YearSelfInspection> getYearSelfCheck();

    /**
     * 获取年度告警统计信息
     */
    AlarmSituation getRfidWarning();

    /**
     * @param type 类型（1：上半年，2：下半年）
     * 获取业务统计信息
     */
    List<BusinessSituation> getBusinessNum(Integer type) throws ParseException;

    /**
     * @param type 类型（1：本季度，2：本年）
     * 获取各市告警统计信息
     */
    List<AlarmSituation> getRfidWarningDetail(Integer type);

    /**
     * 获取各市最近一次自查和核查装备数量
     */
    List<Check> getCheckNum();

    /**
     * @param type 类型（1：上半年，2：下半年）
     * 获取核查统计信息
     */
    List<Verification> getConfirmCheck(Integer type) throws ParseException;

    /**
     * 获取专管员概要信息统计
     */
    UserGeneralSituation getUserGeneralSituation();

    /**
     * 获取工作台统计
     */
    WorkBench getWorkBenchStat();
}
