package com.tykj.dev.device.storage.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.apply.service.DeviceApplyBillService;
import com.tykj.dev.device.apply.subject.domin.DeviceApplyBill;
import com.tykj.dev.device.apply.subject.vo.ApplyBillDetailVo;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.service.DeviceLogService;
import com.tykj.dev.device.library.subject.Dto.DeviceLogDto;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.DeviceLibrarySaveVo;
import com.tykj.dev.device.library.subject.vo.FileVo;
import com.tykj.dev.device.packing.service.PackingLibraryService;
import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import com.tykj.dev.device.storage.service.StorageBillService;
import com.tykj.dev.device.storage.subject.domin.StorageBill;
import com.tykj.dev.device.storage.subject.vo.*;
import com.tykj.dev.device.task.service.TaskLogService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.user.read.service.MessageService;
import com.tykj.dev.device.user.read.subject.bto.MessageBto;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.device.user.util.UserUtils;
import com.tykj.dev.misc.base.BusinessEnum;
import com.tykj.dev.misc.base.StatusEnum;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.*;
import com.tykj.dev.socket.MyWebSocket;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.function.Function;

import static java.util.stream.Collectors.toMap;

/**
 * @author dengdiyi
 */
@RestController
@RequestMapping(value = "/storage")
@AutoDocument
@Api(tags = "装备入库模块", description = "装备入库接口")
public class StorageBillController {
    @Autowired
    TaskService taskService;
    @Autowired
    private StorageBillService storageBillService;
    @Autowired
    private DeviceLibraryService deviceLibraryService;

    @Autowired
    private UserUtils userUtils;

    @Autowired
    private PackingLibraryService packingLibraryService;

    @Autowired
    private DeviceLogService deviceLogService;

    @Autowired
    private TaskLogService taskLogService;

    @Autowired
    private UserPublicService userPublicService;

    @Autowired
    private MyWebSocket myWebSocket;

    @Autowired
    private MessageService messageService;

    @Autowired
    private DeviceLibraryDao deviceLibraryDao;

    @Autowired
    private Snowflake snowflake;

    @Autowired
    private DeviceApplyBillService deviceApplyBillService;

    @ApiOperation(value = "自动生成序列号", notes = "可以通过这个接口自动生成序列号")
    @PostMapping(value = "/autoCreate/{num}")
    public ResponseEntity autoCreate(@PathVariable("num") int num){
        Long seq = snowflake.creatNextId();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(seq);
        if (num>1) {
            stringBuffer.append("-");
            stringBuffer.append(seq + num - 1);
        }
        return ResponseEntity.ok(stringBuffer.toString());
    }

    @ApiOperation(value = "获取序列号区间列表", notes = "可以通过这个接口获取序列号区间列表")
    @GetMapping(value = "/getSeq/{num}/{string}")
    public ResponseEntity getSeq(@PathVariable("string") String s,@PathVariable("num") Integer num){
        List<String> strings = DeviceSeqUtil.createDeviceSeqs(s,num);
        strings.forEach(s1 -> {
            if (deviceLibraryDao.getAllBySeqNumber(s1).size()>0){
                throw new ApiException("序列号"+s1+"已存在");
            }
        });
        return ResultUtil.success(DeviceSeqUtil.createDeviceSeqs(s,num));
    }

    @ApiOperation(value = "选择入库型号数量", notes = "可以通过这个接口选择入库型号数量")
    @PostMapping(value = "/addStorageDetail")
    public ResponseEntity addStorageDetail(@RequestBody List<StorageBillDetailVo> list) {
        List<PackingLibrary> libraryEntities = new ArrayList<>();
        Map<Integer, List<PackingLibrary>> map = new HashMap<>();
        for (StorageBillDetailVo s : list) {
            if (s.getStorageCount()>0) {
                List<String> strings = DeviceSeqUtil.createDeviceSeqs(s.getSeqInterval(), s.getStorageCount());
                List<String> strings3 = DeviceSeqUtil.createDeviceSeqs(s.getProdInterval(), s.getStorageCount());
                List<List<String>> sons = new ArrayList<>();
                List<List<String>> sons2 = new ArrayList<>();
                int count = 1;
                Integer deviceNum = s.getStorageCount();
                while (deviceNum >= count) {
                    PackingLibrary packingLibraryEntity = new PackingLibrary();
                    BeanUtils.copyProperties(packingLibraryService.getOne(s.getPackingId()), packingLibraryEntity);
                    packingLibraryEntity.setCorresponding(count);
                    if (!strings3.isEmpty()) {
                        packingLibraryEntity.setProdNumber(strings3.get(0));
                        strings3.remove(0);
                    }
                    if (!strings.isEmpty()) {
                        if (deviceLibraryDao.getAllBySeqNumber(strings.get(0)).size() > 0) {
                            throw new ApiException("序列号" + strings.get(0) + "已存在");
                        }
                        packingLibraryEntity.setSeq(strings.get(0));
                        strings.remove(0);
                    }
                    libraryEntities.add(packingLibraryEntity);
                    if (s.getList() != null && s.getList().size() != 0) {
                        for (int j = 0; j < s.getList().size(); j++) {
                            StorageBillDetailVo s2 = s.getList().get(j);
                            if (j >= sons.size()) {
                                sons.add(DeviceSeqUtil.createDeviceSeqs(s2.getSeqInterval(), s2.getStorageCount()));
                                sons2.add(DeviceSeqUtil.createDeviceSeqs(s2.getProdInterval(), s2.getStorageCount()));
                            }
                            packingLibraryEntity = packingLibraryService.getOne(s2.getPackingId());
                            List<String> strings2 = sons.get(j);
                            List<String> strings1 = sons2.get(j);
                            if (s2.getStorageCount() >= count) {
                                packingLibraryEntity.setCorresponding(count);
                                if (!strings2.isEmpty()) {
                                    if (deviceLibraryDao.getAllBySeqNumber(strings2.get(0)).size() > 0) {
                                        throw new ApiException("序列号" + strings2.get(0) + "已存在");
                                    }
                                    packingLibraryEntity.setSeq(strings2.get(0));
                                    strings2.remove(0);
                                }
                                if (!strings1.isEmpty()) {
                                    packingLibraryEntity.setProdNumber(strings1.get(0));
                                    strings1.remove(0);
                                }
                                libraryEntities.add(packingLibraryEntity);
                            }
                            if (s2.getStorageCount() - strings2.size() == deviceNum) {
                                List<PackingLibrary> packingLibraries = new ArrayList<>();
                                for (int i = 0; i < s2.getStorageCount() - deviceNum; i++) {
                                    packingLibraryEntity = packingLibraryService.getOne(s2.getPackingId());
                                    packingLibraryEntity.setCorresponding(0);
                                    if (!strings2.isEmpty()) {
                                        if (deviceLibraryDao.getAllBySeqNumber(strings2.get(0)).size() > 0) {
                                            throw new ApiException("序列号" + strings2.get(0) + "已存在");
                                        }
                                        packingLibraryEntity.setSeq(strings2.get(0));
                                        strings2.remove(0);
                                    }
                                    if (!strings1.isEmpty()) {
                                        packingLibraryEntity.setProdNumber(strings1.get(0));
                                        strings1.remove(0);
                                    }
                                    packingLibraries.add(packingLibraryEntity);
                                }
                                map.put(s2.getPackingId(), packingLibraries);
                            }
                        }

                    }
                    count = count + 1;
                }
            }
        }
        for (Integer i : map.keySet()) {
            libraryEntities.addAll(map.get(i));
        }
        return ResultUtil.success(libraryEntities);
    }

    @ApiOperation(value = "添加入库单", notes = "可以通过这个接口发起入库业务")
    @PostMapping(value = "/addStorageBill")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity addStorageBill(@RequestBody @Validated StorageBillSaveVo storageBillSaveVo) {
        //是否申请业务导入
        List<DeviceApplyBill> deviceApplyBills = new ArrayList<>();
        Map<Integer, ApplyBillDetailVo> map = new HashMap<>();
        if (storageBillSaveVo.getApplyTaskIds()!=null&&storageBillSaveVo.getApplyTaskIds().size()>0){
            for (Integer id:storageBillSaveVo.getApplyTaskIds()) {
                TaskBto taskBto1 = taskService.get(id);
                DeviceApplyBill deviceApplyBill = deviceApplyBillService.getOne(taskBto1.getBillId());
                if (deviceApplyBill.getApplyStat()!=null){
                    List<ApplyBillDetailVo> applyBillDetailVos = Objects.requireNonNull(JacksonUtil.readValue(deviceApplyBill.getApplyStat(), new TypeReference<List<ApplyBillDetailVo>>() {
                    }));
                    deviceApplyBill.setApplyBillDetailVos(applyBillDetailVos);
                    map.putAll(applyBillDetailVos.stream().collect(toMap(ApplyBillDetailVo::getPackingId, Function.identity())));
                }
                deviceApplyBills.add(deviceApplyBill);
            }
        }
        //1.存入库单
        Integer userId = userUtils.getCurrentUserId();
        List<Integer> userIds = new ArrayList<>();
        userIds.add(userId);
        StorageBill storageBillEntity;
        TaskBto taskEntity1;
        if (storageBillSaveVo.getTaskId()==null) {
            storageBillEntity = storageBillService.addEntity(storageBillSaveVo.toDo());
            //2.发起入库任务
            TaskBto taskBto = new TaskBto(StatusEnum.END.id, "入库业务", null, ".", storageBillEntity.getId(), 2, userUtils.getCurrentUnitId(), 0, null, userIds);
            taskEntity1 = taskService.start(taskBto);
        }
        else {
            taskEntity1 = taskService.get(storageBillSaveVo.getTaskId());
            StorageBill storageBill = storageBillService.getOne(taskEntity1.getBillId());
            StorageBill storageBill1 = storageBillSaveVo.toDo();
            MapperUtils.copyNoNullProperties(storageBill1,storageBill);
            storageBillEntity = storageBillService.update(storageBill);
            //结束Task
            taskService.addInvolveUser(taskEntity1,userId);
            taskService.moveToEnd(taskEntity1);
        }
        Integer storageBillId = storageBillEntity.getId();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("x");
        //存业务日志
        List<FileVo> fileVoList = new ArrayList<>();
        fileVoList.add(new FileVo("配发单", storageBillEntity.getFileName(), storageBillEntity.getFileUrl()));
//        fileVoList.add(new FileVo("入库确认单", storageBillEntity.getReceiveFileName(), storageBillEntity.getReceiveFileUrl()));
//        //添加业务日志
//        TaskLogBto taskLogBto2 = new TaskLogBto(taskEntity1.getId(), "发起装备入库", fileVoList);
//        taskLogService.addLog(taskLogBto2);
        //3.存装备
        Integer parentId = null;
        List<DeviceLogDto> deviceLogDtos = new ArrayList<>();
        for (DeviceLibrarySaveVo d : storageBillSaveVo.getDeviceLibrarySaveVoList()) {
            if (d.getRfidCardId()==null|| "".equals(d.getRfidCardId()) ||deviceLibraryDao.getAllByRfidCardId(d.getRfidCardId()).size()==0) {
                DeviceLibrary saveEntity = new DeviceLibrary();
                DeviceLibrary deviceLibraryEntity = new DeviceLibrary();
                PackingLibrary packingLibraryEntity = packingLibraryService.getOne(d.getPackingId());
                BeanUtils.copyProperties(packingLibraryEntity, deviceLibraryEntity);
                deviceLibraryEntity.setId(null);
                deviceLibraryEntity.setLifeStatus(2);
                BeanUtils.copyProperties(d, deviceLibraryEntity);
                deviceLibraryEntity.setStorageBillId(storageBillId);
                deviceLibraryEntity.setLocationUnit(userUtils.getCurrentUserUnitName());
                deviceLibraryEntity.setOwnUnit(userUtils.getCurrentUserUnitName());
                deviceLibraryEntity.setPartParentId(null);
                if (deviceLibraryEntity.getRfidCardId()==null||"".equals(deviceLibraryEntity.getRfidCardId())){
                    deviceLibraryEntity.setRfidCardId(null);
                }
                //如果不是单独的配件，设置父装备id为上一个装备的id
                if (d.getIsSinglePart() == 0) {
                    if (deviceLibraryEntity.getIsPart() == 0) {
                        saveEntity = deviceLibraryService.addEntity(deviceLibraryEntity);
                        parentId = saveEntity.getId();
                    }
                    if (deviceLibraryEntity.getIsPart() == 1) {
                        deviceLibraryEntity.setPartParentId(parentId);
                        saveEntity = deviceLibraryService.addEntity(deviceLibraryEntity);
                    }
                }
                //如果是单独的配件，不用设置父装备id
                else {
                    saveEntity = deviceLibraryService.addEntity(deviceLibraryEntity);
                }
                stringBuffer.append(saveEntity.getId());
                //存装备日志
                DeviceLogDto deviceLogDto = new DeviceLogDto(saveEntity.getId(), "发起装备入库", fileVoList);
                deviceLogDtos.add(deviceLogDto);
                stringBuffer.append("x");
                //申请业务列装入库数量+1
                if (map.get(d.getPackingId())!=null){
                    ApplyBillDetailVo applyBillDetailVo = map.get(d.getPackingId());
                    applyBillDetailVo.setCompleteCount(applyBillDetailVo.getCompleteCount()+1);
                    map.put(d.getPackingId(),applyBillDetailVo);
                }
            }
            else {
                throw new ApiException("系统中已存在rfid卡号为"+d.getRfidCardId()+"的装备！");
            }
        }
        //更新申请业务入库数量
        if (deviceApplyBills.size()>0){
            deviceApplyBills.forEach(deviceApplyBill -> {
                List<ApplyBillDetailVo> applyBillDetailVos = deviceApplyBill.getApplyBillDetailVos();
                boolean isEnd = true;
                for (int i = 0;i<applyBillDetailVos.size();i++){
                    ApplyBillDetailVo applyBillDetailVo = applyBillDetailVos.get(i);
                    if (map.get(applyBillDetailVo.getPackingId())!=null){
                        applyBillDetailVo.setCompleteCount(map.get(applyBillDetailVo.getPackingId()).getCompleteCount());
                        applyBillDetailVos.set(i,applyBillDetailVo);
                        if (!applyBillDetailVo.getStorageCount().equals(applyBillDetailVo.getCompleteCount())){
                            isEnd = false;
                        }
                    }
                }
                if (isEnd) {
                    TaskBto taskBto1 = taskService.get(deviceApplyBill.getId(), 9);
                    taskService.moveToEnd(taskBto1);
                    //发送阅知信息
                    MessageBto messageBto = new MessageBto();
                    messageBto.setContent("业务办结");
                    messageBto.setTaskId(taskBto1.getId());
                    messageBto.setIsHighLight(0);
                    messageBto.setInvolveUserIdList(userPublicService.findOtherUser(userId));
                    messageBto.setBusinessType(taskBto1.getBusinessType());
                    messageService.add(messageBto);
                }
                deviceApplyBill.setApplyStat(JacksonUtil.toJSon(applyBillDetailVos));
                deviceApplyBillService.update(deviceApplyBill);
            });
        }
        deviceLogService.addAllLog(deviceLogDtos);
        //4.更新入库单入库详情
        storageBillEntity.setStorageDetail(stringBuffer.toString());
        storageBillService.update(storageBillEntity);
        //发送阅知信息
        MessageBto messageBto = new MessageBto();
        messageBto.setContent("完成装备入库");
        messageBto.setTaskId(taskEntity1.getId());
        messageBto.setIsHighLight(1);
        messageBto.setInvolveUserIdList(userPublicService.findOtherUser(userId));
        messageBto.setBusinessType(taskEntity1.getBusinessType());
        messageService.add(messageBto);
        myWebSocket.sendMessage1();
        return ResultUtil.success(taskEntity1);
    }

    @ApiOperation(value = "入库审核", notes = "可以通过这个接口入库审核")
    @PostMapping(value = "/confirmStorageBill")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity confirmStorageBill(@RequestBody @Validated StorageBillConfirmVo storageBillConfirmVo) {
        TaskBto taskBto = taskService.get(storageBillConfirmVo.getTaskId());
        //1.审核成功,入库任务结束，发起新的确认任务,改变装备状态
        if (storageBillConfirmVo.getStatus() == 0) {
            taskService.update(taskService.moveToEnd(taskBto));
            StorageBill storageBillEntity = storageBillService.getOne(taskBto.getBillId());
            storageBillEntity.setStorageStatus(2);
            storageBillService.update(storageBillEntity);
            List<DeviceLibrary> libraryEntities = deviceLibraryService.getListByBillId(taskBto.getBillId());
            //改变装备状态，添加装备日志
            for (DeviceLibrary d : libraryEntities) {
                d.setLifeStatus(2);
                deviceLibraryService.update(d);
                DeviceLogDto deviceLogDto = new DeviceLogDto(d.getId(), "入库审核成功", null);
                deviceLogService.addLog(deviceLogDto);
            }
            myWebSocket.sendMessage1();
            return ResultUtil.success("审核通过入库成功");
        }
        //2.审核失败
        if (storageBillConfirmVo.getStatus() == 1) {
            taskService.update(taskService.moveToArchive(taskBto));
            StorageBill storageBillEntity = storageBillService.getOne(taskBto.getBillId());
            storageBillEntity.setStorageStatus(1);
            storageBillService.update(storageBillEntity);
            List<DeviceLibrary> libraryEntities = deviceLibraryService.getListByBillId(taskBto.getBillId());
            //改变装备状态，添加装备日志
            for (DeviceLibrary d : libraryEntities) {
                d.setLifeStatus(1);
                deviceLibraryService.update(d);
                DeviceLogDto deviceLogDto = new DeviceLogDto(d.getId(), "入库审核失败", null);
                deviceLogService.addLog(deviceLogDto);
            }
            myWebSocket.sendMessage1();
            return ResultUtil.success("入库审核失败");
        } else {
            return ResultUtil.failed("status只能为0或1");
        }
    }

    @ApiOperation(value = "查询入库详情", notes = "可以通过这个接口查询入库详情")
    @GetMapping(value = "/detail/{billId}")
    public ResponseEntity selectDetail(@PathVariable("billId") int billId) {
        Map<Integer,DeviceLibrary> deviceLibraryMap = deviceLibraryService.getAllDeviceMap();
        StorageDetailVo storageDetailVo = new StorageDetailVo();
        //获取taskBto和账单
        TaskBto taskBto = taskService.get(billId, BusinessEnum.STORAGE.id);
        StorageBill storageBillEntity = storageBillService.getOne(billId);
        if (storageBillEntity.getReceiveUseraId()!=null) {
            storageBillEntity.setReceiveUserA(userPublicService.getOne(storageBillEntity.getReceiveUseraId()).getName());
        }
        if (storageBillEntity.getReceiveUserbId()!=null) {
            storageBillEntity.setReceiveUserB(userPublicService.getOne(storageBillEntity.getReceiveUserbId()).getName());
        }
        storageDetailVo.setStorageBill(storageBillEntity);
        String str = storageBillEntity.getStorageDetail();
        List<Integer> list1 = StringSplitUtil.userIdSplit(str);
        //获取入库装备
        List<DeviceLibrary> libraryEntities = new ArrayList<>();
        for (Integer deviceId : list1) {
            DeviceLibrary deviceLibraryEntity = deviceLibraryMap.get(deviceId);
            libraryEntities.add(deviceLibraryEntity);
        }
        storageDetailVo.setDeviceLibraryList(libraryEntities);
        //获取业务日志
        storageDetailVo.setTaskLogUserVos(taskLogService.getByTaskId(taskBto.getId()));
        return ResultUtil.success(storageDetailVo);
    }

    @ApiOperation(value = "保存入库单", notes = "可以通过这个接口保存入库单")
    @PostMapping(value = "/saveStorageBill")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity saveStorageBill(@RequestBody StorageBillSaveVo storageBillSaveVo) {
        //第一次保存
        if (storageBillSaveVo.getTaskId()==null){
            //保存入库单
            Integer userId = userUtils.getCurrentUserId();
            List<Integer> userIds = new ArrayList<>();
            userIds.add(0);
            StorageBill storageBill1 = storageBillSaveVo.toDo();
            storageBill1.setStorageStatus(0);
            StorageBill storageBill = storageBillService.addEntity(storageBill1);
            //发起任务
            TaskBto taskBto = new TaskBto(StatusEnum.WAIT_STORAGE.id, "入库业务", null, ".", storageBill.getId(), 2, userUtils.getCurrentUnitId(), 0, null, userIds);
            TaskBto taskBto1 = taskService.start(taskBto);
            myWebSocket.sendMessage1();
            return ResponseEntity.ok("保存成功"+taskBto1.getId());
        }
        else {
            //更新账单
            TaskBto taskBto = taskService.get(storageBillSaveVo.getTaskId());
            StorageBill storageBill = storageBillService.getOne(taskBto.getBillId());
            StorageBill storageBill1 = storageBillSaveVo.toDo();
            storageBill1.setStorageStatus(0);
            MapperUtils.copyNoNullProperties(storageBill1,storageBill);
            storageBillService.update(storageBill);
            return ResponseEntity.ok("更新成功"+taskBto.getId());
        }
    }

    @ApiOperation(value = "删除入库单草稿", notes = "可以通过这个接口删除入库单草稿")
    @PostMapping(value = "/deleteStorageBill/{taskId}")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity deleteStorageBill(@PathVariable("taskId") int taskId) {
        //任务封存
        TaskBto taskBto = taskService.get(taskId);
        TaskBto taskBto1 = taskService.addInvolveUser(taskBto,userUtils.getCurrentUserId());
        taskService.moveToArchive(taskBto1);
        myWebSocket.sendMessage1();
        return ResponseEntity.ok("删除成功");
    }

    @ApiOperation(value = "查询待入库详情", notes = "可以通过这个接口查询待入库详情")
    @PostMapping(value = "/selectStorageDetail/{taskId}")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity selectStorageDetail(@PathVariable("taskId") int taskId) {
        TaskBto taskBto = taskService.get(taskId);
        StorageBill storageBillEntity = storageBillService.getOne(taskBto.getBillId());
        storageBillEntity.setReceiveUserA(userPublicService.getOne(storageBillEntity.getReceiveUseraId()).getName());
        storageBillEntity.setReceiveUserB(userPublicService.getOne(storageBillEntity.getReceiveUserbId()).getName());
        storageBillEntity.setReplyFileList(FilesUtil.stringFileToList(storageBillEntity.getReplyFiles()));
        storageBillEntity.setApplyFileList(FilesUtil.stringFileToList(storageBillEntity.getApplyFiles()));
        List<StorageBillDetail> storageBillDetails = JacksonUtil.readValue(storageBillEntity.getPackingDetail(), new TypeReference<List<StorageBillDetail>>() {
        });
//        if (storageBillDetailVos != null) {
//            setPackingLibrary(storageBillDetailVos);
//        }
        storageBillEntity.setStorageBillDetails(storageBillDetails);
        return ResponseEntity.ok(storageBillEntity);
    }

//    private void setPackingLibrary(List<StorageBillDetailVo> storageBillDetailVos){
//        storageBillDetailVos.forEach(storageBillDetailVo -> {
//            storageBillDetailVo.setPackingLibrary(packingLibraryService.getOne(storageBillDetailVo.getPackingId()));
//            if (storageBillDetailVo.getList()!=null&&storageBillDetailVo.getList().size()>0){
//                setPackingLibrary(storageBillDetailVo.getList());
//            }
//        });
//    }
}
