package com.tykj.dev.device.storage.service.impl;

import com.tykj.dev.blockcha.subject.entity.BcHash;
import com.tykj.dev.blockcha.subject.service.BlockChainUtil;
import com.tykj.dev.config.TaskBeanConfig;
import com.tykj.dev.device.storage.repository.StorageBillDao;
import com.tykj.dev.device.storage.service.StorageBillService;
import com.tykj.dev.device.storage.subject.domin.StorageBill;
import com.tykj.dev.misc.utils.JacksonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

/**
 * @author dengdiyi
 */
@Service
public class StorageBillServiceImpl implements StorageBillService {

    @Autowired
    private StorageBillDao storageBillDao;

    @Autowired
    private BlockChainUtil blockChainUtil;

    @Override
    public StorageBill addEntity(StorageBill storageBillEntity) {
        StorageBill storageBill = storageBillDao.save(storageBillEntity);
        CompletableFuture.runAsync(()->{
            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            StorageBill storageBill1 = getOne(storageBill.getId());
            BcHash bcText = blockChainUtil.sendHash(1000, JacksonUtil.toJSon(storageBill1));
            String recordId = bcText.getData().getRecordID();
            storageBill1.setRecordId(recordId);
            storageBillDao.save(storageBill1);
        }, TaskBeanConfig.getThreadPoolTaskScheduler());
        return storageBill;
    }

    /**
     * @param storageBills 异步上链
     */
    @Override
    @Async
    public void sendHash(List<StorageBill> storageBills) {
        storageBills.forEach(storageBill -> {
            BcHash bcText = blockChainUtil.sendHash(1000, JacksonUtil.toJSon(storageBill));
            String recordId = bcText.getData().getRecordID();
            storageBill.setRecordId(recordId);
            update(storageBill);
        });
    }

    @Override
    public Page<StorageBill> getPage(StorageBill storageBillEntity, Pageable pageable) {
        return null;
    }

    @Override
    public List<StorageBill> getList(StorageBill storageBillEntity) {
        return null;
    }

    @Override
    public StorageBill update(StorageBill storageBillEntity) {
        StorageBill storageBill = storageBillDao.save(storageBillEntity);
        CompletableFuture.runAsync(()->blockChainUtil.appendHash(JacksonUtil.toJSon(storageBill),storageBill.getRecordId()),TaskBeanConfig.getThreadPoolTaskScheduler());
        return storageBill;
    }

    @Override
    public StorageBill getOne(Integer id) {
        Optional<StorageBill> storageBillEntity = storageBillDao.findById(id);
        return storageBillEntity.orElse(null);
    }

    @Override
    public void delete(Integer id) {
        storageBillDao.deleteById(id);
    }
}
