package com.tykj.dev.device.task.utils;

import com.tykj.dev.device.task.subject.domin.TaskLog;
import com.tykj.dev.device.task.subject.vo.TaskUserVo;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 * task工具类
 */
@Component
public class TaskUtils {

    /**
     * @param list 业务日志list
     *             按照日志创建时间降序排列
     */
    public List<TaskLog> orderByCreateTimeDesc(List<TaskLog> list) {
        list.sort(Comparator.comparing(TaskLog::getCreateTime,Comparator.nullsLast(Date::compareTo)).reversed());
        return list;
    }

    /**
     * @param list 业务日志list
     *             按照日志创建时间增序排列
     */
    public List<TaskLog> orderByCreateTimeAsc(List<TaskLog> list) {
        list.sort(Comparator.comparing(TaskLog::getCreateTime,Comparator.nullsLast(Date::compareTo)));
        return list;
    }

    /**
     * @param list taskUserVo list
     *             按照跟踪时间增序排列
     */
    public List<TaskUserVo> orderByUserTimeDateAsc(List<TaskUserVo> list) {
        list.sort(Comparator.comparing(TaskUserVo::getUserTimeDate,Comparator.nullsLast(Date::compareTo)));
        return list;
    }

    /**
     * @param list taskUserVo list
     *             按照跟踪时间降序排列
     */
    public List<TaskUserVo> orderByUserTimeDateDesc(List<TaskUserVo> list) {
        list.sort(Comparator.comparing(TaskUserVo::getUserTimeDate,Comparator.nullsLast(Date::compareTo)).reversed());
        return list;
    }

    /**
     * @param list taskUserVo list
     *             按照待办时间增序排列
     */
    public List<TaskUserVo> orderByTrackingTimeDateAsc(List<TaskUserVo> list) {
        list.sort(Comparator.comparing(TaskUserVo::getTrackingTimeDate,Comparator.nullsLast(Date::compareTo)));
        return list;
    }

    /**
     * @param list taskUserVo list
     *             按照待办时间降序排列
     */
    public List<TaskUserVo> orderByTrackingTimeDateDesc(List<TaskUserVo> list) {
        list.sort(Comparator.comparing(TaskUserVo::getTrackingTimeDate,Comparator.nullsLast(Date::compareTo)).reversed());
        return list;
    }

    /**
     * @param list taskUserVo list
     *             按照发起时间降序排列
     */
    public List<TaskUserVo> orderByCreateTimeDesc2(List<TaskUserVo> list) {
        list.sort(Comparator.comparing(TaskUserVo::getCreateTime,Comparator.nullsLast(Date::compareTo)).reversed());
        return list;
    }

    /**
     * @param list taskUserVo list
     *             按照发起时间升序排列
     */
    public List<TaskUserVo> orderByCreateTimeAsc2(List<TaskUserVo> list) {
        list.sort(Comparator.comparing(TaskUserVo::getCreateTime,Comparator.nullsLast(Date::compareTo)));
        return list;
    }

    /**
     * @param taskUserVos 按置顶第一顺序，未读第二顺序排序输出
     */
    public List<TaskUserVo> orderByTopDescAndReadAsc(List<TaskUserVo> taskUserVos) {
        List<TaskUserVo> list = new ArrayList<>();
        List<TaskUserVo> list1 = new ArrayList<>();
        List<TaskUserVo> list2 = new ArrayList<>();
        //将置顶筛选到list1
        for (TaskUserVo t : taskUserVos) {
            if (t.getIsTop() == 1) {
                list1.add(t);
            }
        }
        //list1中将未读的放在list最前面
        for (TaskUserVo t : list1) {
            if (t.getIsRead() == 0) {
                list.add(t);
            }
        }
        //list1中将已读的放在list最后面
        for (TaskUserVo t : list1) {
            if (t.getIsRead() == 1) {
                list.add(t);
            }
        }
        //将未置顶的放入list2中
        for (TaskUserVo t : taskUserVos) {
            if (t.getIsTop() == 0) {
                list2.add(t);
            }
        }
        //将未读的优先放入list中
        for (TaskUserVo t : list2) {
            if (t.getIsRead() == 0) {
                list.add(t);
            }
        }
        //将已读的放入list
        for (TaskUserVo t : list2) {
            if (t.getIsRead() == 1) {
                list.add(t);
            }
        }
        return list;
    }

    /**
     * @param taskUserVos 按置顶顺序排序输出
     */
    public List<TaskUserVo> orderByTopDesc(List<TaskUserVo> taskUserVos) {
        List<TaskUserVo> list = new ArrayList<>();
        for (TaskUserVo t : taskUserVos) {
            if (t.getIsTop() == 1) {
                list.add(t);
            }
        }
        for (TaskUserVo t : taskUserVos) {
            if (t.getIsTop() == 0) {
                list.add(t);
            }
        }
        return list;
    }
}
