package com.tykj.dev.device.train.controller;

import com.tykj.dev.blockcha.subject.entity.BcHash;
import com.tykj.dev.blockcha.subject.entity.BcText;
import com.tykj.dev.blockcha.subject.service.BlockChainUtil;
import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.task.service.TaskLogService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.bto.TaskLogBto;
import com.tykj.dev.device.train.dao.TrainUserDao;
import com.tykj.dev.device.train.entity.TrainTheme;
import com.tykj.dev.device.train.entity.TrainUser;
import com.tykj.dev.device.train.entity.vo.*;
import com.tykj.dev.device.train.service.TrainTaskService;
import com.tykj.dev.device.train.service.TrainThemeService;
import com.tykj.dev.device.user.read.service.MessageService;
import com.tykj.dev.device.user.read.subject.bto.MessageBto;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.device.user.subject.entity.UserLog;
import com.tykj.dev.device.user.subject.service.MgrcertService;
import com.tykj.dev.device.user.subject.service.UserLogService;
import com.tykj.dev.device.user.subject.service.UserService;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.base.BusinessEnum;
import com.tykj.dev.misc.base.StatusEnum;
import com.tykj.dev.misc.utils.JacksonUtil;
import com.tykj.dev.misc.utils.TaskDisposeUtil;
import com.tykj.dev.socket.MyWebSocket;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.checkerframework.checker.units.qual.A;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;


/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TrainJobController.java
 * @Description TODO
 * @createTime 2020年08月16日 21:26:00
 */
@RestController
@RequestMapping(value = "/job/train")
@AutoDocument
@Api(tags = "专管员培训业务", description = "培训业务接口")
@Slf4j
public class TrainJobController {

    @Autowired
    TrainThemeService trainThemeService;
    @Autowired
    MgrcertService mgrcertService;
    @Autowired
    UnitsDao unitsDao;
    @Autowired
    UserService userService;
    @Autowired
    MyWebSocket myWebSocket;
    @Autowired
    TaskService taskService;
    @Autowired
    TrainTaskService trainTaskService;
    @Autowired
    TaskLogService taskLogService;
    @Autowired
    TrainUserDao trainUserDao;
    @Autowired
    UserLogService userLogService;

    @Autowired
    BlockChainUtil blockChainUtil;

    @Autowired
    MessageService messageService;



    // 发起培训给选中人员都发一个代办任务报名，此任务在发起人跟踪里

    /**
     * 新建培训信息
     * 首先创建task(发起人task) 在创建状态为新建(id_done为1)以及报名中待job，在给所有的专管员发起一个job（待报名）
     */
    @ApiOperation(value = "1.培训业务新建接口", notes = "有两类人员，一必须培训的人员，这里状态为报名确认，只需要确认就ok，2。不是必须报名的人员 状态 待报名，需要让用户选择报名 或不报名")
    @PostMapping("/initiate")
    public ResponseEntity newTrain(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody TrainThemeAddVo trainThemeAddVo) {
        TrainTheme trainTheme = trainThemeService.save(trainThemeAddVo.toDo());
//        List<User> userList = userService.findSubordinate(securityUser.getCurrentUserInfo().getUserId());
        List<User> userList=userService.findUnitsIdInUsers(trainThemeAddVo.getUnitsIds());

        List<Integer> needTrain = new ArrayList<>();
        List<Integer> normal =  new ArrayList<>();

        userList.forEach(
                user -> {
            if (user.getTrainStatus()==1 || user.getTrainStatus()==2){
                needTrain.add(user.getUserId());
            }else {
                normal.add(user.getUserId());
            }
                }
        );
        // 1.用户报名
          userService.findAllUserIdInUser(needTrain).forEach(
                  user -> {
                     TrainUser trainUser= userToTrainUser(user);
                     trainUser.setIsSignUp(2);
                     trainUser.setIsNotJoinUserId(1);
                     trainUser.setTrainId(trainTheme.getTrainId());
                     saveTrainUser(trainUser);
                  }
          );

        userService.findAllUserIdInUser(normal).forEach(
                user -> {
                    TrainUser trainUser= userToTrainUser(user);
                    trainUser.setIsSignUp(2);
                    trainUser.setIsNotJoinUserId(0);
                    trainUser.setTrainId(trainTheme.getTrainId());
//                    trainUserDao.save(trainUser);
                    saveTrainUser(trainUser);
                }
        );

        List<Integer> integers = new ArrayList<>();
        integers.add(securityUser.getCurrentUserInfo().getUserId());
        TaskBto task = taskService.start(new TaskBto(StatusEnum.TRAIN1000.id, trainTheme.getName(), null, null, trainTheme.getTrainId(), BusinessEnum.TRAIN.id, securityUser.getCurrentUserInfo().getUnitsId(), 0, null, integers));

        trainTheme.setTrainStatus(StatusEnum.TRAIN1000.id);

        trainThemeAddVo.getUnitsIds().forEach(
                unitId->{
                    List<Integer> list = new ArrayList<>();
                    list.add(0);
                    taskService.start(new TaskBto(StatusEnum.TRAIN1002.id, trainTheme.getName(), task.getId(), task.getId().toString(), trainTheme.getTrainId(), BusinessEnum.TRAIN.id, unitId, 0, null, list));
                }
        );
        if (securityUser.getCurrentUserInfo().getUnits().getLevel()==1){
            List<Integer> userIds=userService.findAllByUnite(securityUser.getCurrentUserInfo().getUnitsId()).stream().map(User::getUserId).collect(Collectors.toList());
            userIds.remove(securityUser.getCurrentUserInfo().getUserId());
            messageService.add(new MessageBto(task.getId(),BusinessEnum.TRAIN.id,securityUser.getUsername()+"发起培训",userIds));
        }else {
            List<Integer> userIds=userService.findAllByUnite(securityUser.getCurrentUserInfo().getUnitsId()).stream().map(User::getUserId).collect(Collectors.toList());
            userIds.remove(securityUser.getCurrentUserInfo().getUserId());
            userIds.addAll(userService.findAllByUnite(1).stream().map(User::getUserId).collect(Collectors.toList()));
            messageService.add(new MessageBto(task.getId(),BusinessEnum.TRAIN.id,securityUser.getUsername()+"发起培训",userIds));
        }
        myWebSocket.sendMessage1();
        return ResponseEntity.ok(trainThemeService.save(trainTheme));
    }

    //报名

    /**
     * 待报名 （所调用的接口）
     *
     * @param signUpReturn
     * @return
     */
    @ApiOperation(value = "2。报名和确认接口", notes = "若是确认请填写confirm为1，若报名returns=0、若不报名returns=1")
    @PostMapping("/signUp")
    public ResponseEntity signUp(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody signUpReturn signUpReturn) {
        TrainTheme trainTheme = trainThemeService.findById(signUpReturn.getTrainThemeId());
        TaskBto taskBto = taskService.get(signUpReturn.getTaskId());
        TaskDisposeUtil.isNotSubmit(taskBto.getBillStatus(),StatusEnum.TRAIN1002);

        Integer taskId=taskBto.getId();
        List<SignUpUsers> signUpUsers= signUpReturn.getSignUpUsers();
        signUpUsers.forEach(signUpUser -> {
            TrainUser trainUser= trainUserDao.findByUserIdAndTrainId(signUpUser.getUserId(),trainTheme.getTrainId());
            if (signUpUser.getReturns() == 0) {
                trainUser.setIsSignUp(1);
                TaskLogBto taskLogBto = new TaskLogBto(taskId, "报名", null);
                userLogService.save(new UserLog(securityUser.getCurrentUserInfo().getUserId(),new Date(),"报名参加培训"));
                taskLogService.addLog(taskLogBto);
            } else {
                trainUser.setIsSignUp(2);
                trainUser.setNote(signUpUser.getNote());
                TaskLogBto taskLogBto = new TaskLogBto(taskId, "不报名", null);
                taskLogService.addLog(taskLogBto);
                userLogService.save(new UserLog(securityUser.getCurrentUserInfo().getUserId(),new Date(),"不参加培训"));
            }
            trainUser.setUnitsName(unitsDao.findById(trainUser.getUnitsId()).get().getName());
            saveTrainUser(trainUser);
        });
//        if (signUpReturn.getReturns() == 0) {
//            taskBto = taskService.moveToSpecial(taskBto, StatusEnum.TRAIN1003, -1);
//            trainUser.setIsSignUp(1);
//            TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(), "报名", null);
//            userLogService.save(new UserLog(securityUser.getCurrentUserInfo().getUserId(),new Date(),"报名参加培训"));
//            taskLogService.addLog(taskLogBto);
//        } else {
//            trainUser.setIsSignUp(2);
//            trainUser.setNote(signUpReturn.getNote());
//            TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(), "不报名", null);
//            taskLogService.addLog(taskLogBto);
//            taskService.moveToEnd(taskBto);
//            userLogService.save(new UserLog(securityUser.getCurrentUserInfo().getUserId(),new Date(),"不参加培训"));
//        }
        taskBto= taskService.moveToSpecial(taskBto, StatusEnum.TRAIN1003, -1);
        List<Integer> userIds=userService.findAllByUnite(securityUser.getCurrentUserInfo().getUnitsId()).stream().map(User::getUserId).collect(Collectors.toList());
        userIds.addAll(userService.findAllByUnite(trainTheme.getUnitsId()).stream().map(User::getUserId).collect(Collectors.toList()));
        userIds.remove(securityUser.getCurrentUserInfo().getUserId());
        messageService.add(new MessageBto(taskBto.getId(),BusinessEnum.TRAIN.id,securityUser.getUsername()+"提交了培训名单",userIds));

        myWebSocket.sendMessage1();
        return ResponseEntity.ok(taskBto);
    }

    /**
     * 报名结束
     *
     * @param trainId
     * @return
     */
    @GetMapping("/signUpEnd/{trainId}")
    public ResponseEntity signUpEnd(@PathVariable Integer trainId) {
        TrainTheme trainTheme = trainThemeService.findById(trainId);
        //查询所有必须报名而没有报名的task 状态直接转为待培训
        trainTaskService.selectBillidAndBillType(trainId, BusinessEnum.TRAIN.id, StatusEnum.TRAIN1002.id).forEach(
                taskBto -> {
                    taskService.moveToEnd(taskBto);
//                    taskService.moveToSpecial(taskBto, StatusEnum.TRAIN1003, -1);
//                    List<Integer> ids= taskBto.getInvolveUserIdList();
//                    TrainUser trainUser= trainUserDao.findByUserIdAndTrainId(ids.get(ids.size()-1),trainTheme.getTrainId());
//                    trainUser.setIsSignUp(1);
////                    trainUserDao.save(trainUser);
//                    saveTrainUser(trainUser);
//                    userLogService.save(new UserLog(trainUser.getUserId(),new Date(),"报名参加培训"));
                }
        );

        //查询主task
        TaskBto taskBto = trainTaskService.selectFatherIsNullAndBillidAndBillType(trainTheme.getTrainId(), BusinessEnum.TRAIN.id);
//      //主task往下推待培训状态，0
        taskService.moveToSpecial(taskBto, StatusEnum.TRAIN1010, 0);
        //5 待培训
        trainTheme.setTrainStatus(StatusEnum.TRAIN1010.id);
        myWebSocket.sendMessage1();
        return ResponseEntity.ok(trainThemeService.save(trainTheme));
    }

    //培训中
    @GetMapping("/inTraining/{trainId}")
    public ResponseEntity inTraining(@PathVariable Integer trainId) {
        TrainTheme trainTheme = trainThemeService.findById(trainId);
        trainTaskService.selectBillidAndBillType(trainId, BusinessEnum.TRAIN.id, StatusEnum.TRAIN1010.id).forEach(
                taskBto -> taskService.moveToSpecial(taskBto, StatusEnum.TRAIN1004, taskBto.getInvolveUserIdList().get(0))
        );
        //5 培训中
        TaskBto taskBto = trainTaskService.selectFatherIsNullAndBillidAndBillType(trainTheme.getTrainId(), BusinessEnum.TRAIN.id);
//      //主task往下推待培训状态，0
        taskService.moveToSpecial(taskBto, StatusEnum.TRAIN1004, 0);
        trainTheme.setTrainStatus(StatusEnum.TRAIN1004.id);
        myWebSocket.sendMessage1();
        return ResponseEntity.ok(trainThemeService.save(trainTheme));
    }

    //市培训待审核
    @ApiOperation(value = "3 录入成绩后调用的接口", notes = "状态改为'市培训申请发证")
    @PostMapping("/gradesGrade")
    public ResponseEntity cityAudit(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody GradeEntryVo gradeEntryVo) {
        TrainTheme trainTheme = trainThemeService.findById(gradeEntryVo.getTrainThemeId());
//        TaskEntity taskEntity= taskService.findByStartUserIdAndBillIdAndBussType(securityUser.getCurrentUserInfo().getUserId(),trainTheme.getTrainId(),BusinessEnum.TRAIN.id);
        TaskBto taskBto = trainTaskService.selectFatherIsNullAndBillidAndBillType(trainTheme.getTrainId(), BusinessEnum.TRAIN.id);
        //判断
        TaskDisposeUtil.isNotSubmit(taskBto.getBillStatus(),StatusEnum.TRAIN1008);

        taskBto.setOwnUnit(1);
        taskService.moveToSpecial(taskBto, StatusEnum.TRAIN1005);
        gradeEntryVo.getGradeEntryList().forEach(
                gradeEntry -> {
                  TrainUser trainUser = trainUserDao.findByUserIdAndTrainId(gradeEntry.getUserId(),trainTheme.getTrainId());
                  trainUser.setAttendance(gradeEntry.getAttendance());
                  trainUser.setScore(gradeEntry.getScore());
                  trainUser.setEvaluation(gradeEntry.getEvaluation());
                  trainUser.setCertificate(gradeEntry.getCertificate());
//                  trainUserDao.save(trainUser);
                    saveTrainUser(trainUser);
                }
        );
        trainTheme.setTrainStatus(StatusEnum.TRAIN1005.id);
        trainTheme.setGood(gradeEntryVo.getGood());
        trainTheme.setPass(gradeEntryVo.getPass());
        TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(), "申请发证", null);
        taskLogService.addLog(taskLogBto);
        myWebSocket.sendMessage1();
        return ResponseEntity.ok(trainThemeService.save(trainTheme));
    }


    //市培训申请发证审核  待确认
    @ApiOperation(value = "市培训申请发证状态 调用接口", notes = "下一步'市培训申请发证审核'")
    @PostMapping("/isApply")
    public ResponseEntity provinceAudit(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody GradeEntryVo gradeEntryVo) {
        TrainTheme trainTheme = trainThemeService.findById(gradeEntryVo.getTrainThemeId());
        TaskBto taskBto = trainTaskService.selectFatherIsNullAndBillidAndBillType(trainTheme.getTrainId(), BusinessEnum.TRAIN.id);

        //判断
        TaskDisposeUtil.isNotSubmit(taskBto.getBillStatus(),StatusEnum.TRAIN1005);

        taskBto = taskService.addInvolveUser(taskBto, securityUser.getCurrentUserInfo().getUserId());
        taskService.moveToSpecial(taskBto, StatusEnum.TRAIN1006, gradeEntryVo.getAuditId());


        //7 市培训申请发证审核
        trainTheme.setIsCertificate(gradeEntryVo.getIsCertificate());
        gradeEntryVo.getGradeEntryList().forEach(
                gradeEntry -> {
                    TrainUser trainUser = trainUserDao.findByUserIdAndTrainId(gradeEntry.getUserId(),trainTheme.getTrainId());
                    trainUser.setAttendance(gradeEntry.getAttendance());
                    trainUser.setScore(gradeEntry.getScore());
                    trainUser.setEvaluation(gradeEntry.getEvaluation());
                    trainUser.setCertificate(gradeEntry.getCertificate());
//                    trainUserDao.save(trainUser);
                    saveTrainUser(trainUser);
                }
        );
        trainTheme.setTrainStatus(StatusEnum.TRAIN1006.id);
        trainTheme.setGood(gradeEntryVo.getGood());
        trainTheme.setPass(gradeEntryVo.getPass());
        TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(), "发证审核", null);
        taskLogService.addLog(taskLogBto);
        myWebSocket.sendMessage1();
        return ResponseEntity.ok(trainThemeService.save(trainTheme));
    }


    //省培训发证审核
    @PostMapping("/audit")
    public ResponseEntity audit(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody GradeEntryVo gradeEntryVo) {
        TrainTheme trainTheme = trainThemeService.findById(gradeEntryVo.getTrainThemeId());
        TaskBto taskBto = trainTaskService.selectFatherIsNullAndBillidAndBillType(trainTheme.getTrainId(), BusinessEnum.TRAIN.id);

        //判断
        TaskDisposeUtil.isNotSubmit(taskBto.getBillStatus(),StatusEnum.TRAIN1008);


        taskService.moveToSpecial(taskBto, StatusEnum.TRAIN1007, gradeEntryVo.getAuditId());

        //7 省培训发证审核
        trainTheme.setIsCertificate(gradeEntryVo.getIsCertificate());
        gradeEntryVo.getGradeEntryList().forEach(
                gradeEntry -> {
                    TrainUser trainUser = trainUserDao.findByUserIdAndTrainId(gradeEntry.getUserId(),trainTheme.getTrainId());
                    trainUser.setAttendance(gradeEntry.getAttendance());
                    trainUser.setScore(gradeEntry.getScore());
                    trainUser.setEvaluation(gradeEntry.getEvaluation());
                    trainUser.setCertificate(gradeEntry.getCertificate());
//                    trainUserDao.save(trainUser);
                    saveTrainUser(trainUser);
                }
        );
        trainTheme.setTrainStatus(StatusEnum.TRAIN1007.id);
        trainTheme.setGood(gradeEntryVo.getGood());
        trainTheme.setPass(gradeEntryVo.getPass());
        TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(), "发证待审核", null);
        taskLogService.addLog(taskLogBto);
        myWebSocket.sendMessage1();
        return ResponseEntity.ok(trainThemeService.save(trainTheme));
    }


    @ApiOperation(value = "省培训发证审核以及市培训申请发证审核调用接口", notes = "同意培训完成")
    @PostMapping("/auditResult")
    public ResponseEntity gradeeEntry(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody GradeEntryVo gradeEntryVo) {
        //向专管员证书表中添加数据

        gradeEntryVo.getGradeEntryList().forEach(
                gradeEntry -> {
                    if (gradeEntry.getCertificate() == 0) {
                        mgrcertService.save(gradeEntry.toDo());
                        userLogService.save(new UserLog(gradeEntry.getUserId(),new Date(),"通过培训获得证书"));
                    }
                }
        );
        TrainTheme trainTheme = trainThemeService.findById(gradeEntryVo.getTrainThemeId());
        //给培训报名的人员都发起一个通知，查看自己都证书
        TaskBto taskBto = trainTaskService.selectFatherIsNullAndBillidAndBillType(trainTheme.getTrainId(), BusinessEnum.TRAIN.id);

        List<StatusEnum> statusEnums=new ArrayList<>();
        statusEnums.add(StatusEnum.TRAIN1006);
        statusEnums.add(StatusEnum.TRAIN1007);
        TaskDisposeUtil.isNotSubmit(taskBto.getBillStatus(),statusEnums);

        taskService.moveToEnd(taskBto);
//        TaskEntity taskEntity=taskService.findByParentAndBillIdAndBussType(0,trainTheme.getTrainId(),BusinessEnum.TRAIN.id);
//        //8 培训完成


        //9 成绩待确认
        /**
         * 15
         */
        trainTheme.setTrainStatus(StatusEnum.END.id);
        gradeEntryVo.getGradeEntryList().forEach(
                gradeEntry -> {
                    TrainUser trainUser = trainUserDao.findByUserIdAndTrainId(gradeEntry.getUserId(),trainTheme.getTrainId());
                    trainUser.setAttendance(gradeEntry.getAttendance());
                    trainUser.setScore(gradeEntry.getScore());
                    trainUser.setEvaluation(gradeEntry.getEvaluation());
//                    trainUserDao.save(trainUser);
                    saveTrainUser(trainUser);
                }
        );

        trainTaskService.selectBillidAndBillType(gradeEntryVo.getTrainThemeId(), BusinessEnum.TRAIN.id, StatusEnum.TRAIN1003.id).forEach(
                taskBto1 -> {
//                                taskBto1.setCurrentPoint(0);
                    taskService.moveToSpecial(taskBto1, StatusEnum.TRAIN1009,0);
                }
        );
        trainThemeService.save(trainTheme);
        TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(), "审核通过", null);
        taskLogService.addLog(taskLogBto);
        myWebSocket.sendMessage1();
        return ResponseEntity.ok(trainTheme);
        //修改业务都状态
    }




    //考情 1.正常参加 2.为参加 3.请假
    //分数
    //评价 1.优秀 2.良好 3.及格 4 不及格
    private String toString(GradeEntry gradeEntry) {
        return gradeEntry.getUserId() + "-" + gradeEntry.getAttendance() + "-" + gradeEntry.getScore() + "-" + gradeEntry.getCertificate();

    }



    /**
     * 成绩查看确认
     *
     * @param signUpReturn
     * @return
     */
    @ApiOperation(value = "end。成绩查看确认接口")
    @PostMapping("/resultsConfirm")
    public ResponseEntity resultsConfirm(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody signUpReturn signUpReturn) {
        TrainTheme trainTheme = trainThemeService.findById(signUpReturn.getTrainThemeId());
        //给培训报名的人员都发起一个通知，查看自己都证书
        TaskBto taskBto = taskService.get(signUpReturn.getTaskId());
        taskService.moveToEnd(taskBto);
        myWebSocket.sendMessage1();
        return ResponseEntity.ok(true);
    }

    @ApiOperation(value = "报名页面和确认页面接口，查看成绩页面接口")
    @GetMapping("/train/{trainId}")
    public ResponseEntity resultsConfirm(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer trainId) {
        return ResponseEntity.ok(trainThemeService.findByTrainingPeople(trainId, securityUser.getCurrentUserInfo().getUserId()));
    }

    @ApiOperation(value = "报名中请求的详情接口")
    @GetMapping("/trainRegistration/{trainId}")
    public ResponseEntity TrainRegistrationVo(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer trainId) {
        return ResponseEntity.ok(trainThemeService.findRegistrationVo(trainId));
    }

    @ApiOperation(value = "培训中请求接口请求的详情接口")
    @GetMapping("/trainTrainingVo/{trainId}")
    public ResponseEntity TrainTrainingVo(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer trainId) {
        return ResponseEntity.ok(trainThemeService.findTrainTrainingVo(trainId));
    }

    @ApiOperation(value = "审核请求的详情接口")
    @GetMapping("/trainAuditVo/{trainId}")
    public ResponseEntity TrainAuditVo(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer trainId) {
        return ResponseEntity.ok(trainThemeService.findTrainAuditVo(trainId));
    }

    @ApiOperation(value = "培训修改接口")
    @PostMapping("/trainUpdateVo")
    public ResponseEntity TrainRegistrationVo(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody TrainUpdateVo trainUpdateVo) {
        return ResponseEntity.ok(trainThemeService.updateTrain(trainUpdateVo));
    }

    @ApiOperation(value = "培训详情接口查询")
    @GetMapping("/details/{trainId}")
    public ResponseEntity details(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer trainId) {
        return ResponseEntity.ok(trainThemeService.findSelectDetailsVo(trainId));
    }

   private TrainUser userToTrainUser(User user){
       ModelMapper mapper = BeanHelper.getUserMapper();
       return mapper.map(user,TrainUser.class);
   }

    private TrainUser saveTrainUser(TrainUser trainUser){
        TrainUser trainUser1 = trainUserDao.save(trainUser);
            BcHash bcHash=blockChainUtil.sendHash(1000,JacksonUtil.toJSon(trainUser1));
            trainUser1.setRecordId(bcHash.getData().getRecordID());
//            log.info("id----{}",bcHash.getData().getRecordID());
//            blockChainUtil.appendHash(JacksonUtil.toJSon(trainUser1),trainUser1.getRecordId());
            trainUserDao.save(trainUser1);
            return trainUser1;
    }

}
