package com.tykj.dev.device.train.entity;

import com.tykj.dev.device.user.subject.entity.Mgrcert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UserTranitVo.java
 * @Description TODO
 * @createTime 2020年08月18日 17:35:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "培训人员信息")
public class TrainUser {
    /**
     * 数据id
     */
    @Id
    @ApiModelProperty(value = "数据ID", name = "id", example = "12321L")
    @GeneratedValue
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    /**
     * 培训id
     */
    @ApiModelProperty(value = "培训id", name = "userId", example = "12321L")
    private Integer trainId;

    /**
     * 用户
     */
    @ApiModelProperty(value = "用户数据ID", name = "userId", example = "12321L")
    private Integer userId;

    /**
     * 真实名称
     */
    @ApiModelProperty(value = "真实名称", name = "name", example = "12321L")
    private String name;


    /**
     * 移动电话
     */
    @ApiModelProperty(value = "移动电话", name = "mobile", example = "12321L")
    private String mobile;


    /**
     * 身份证
     */
    @ApiModelProperty(value = "身份证", name = "idCard", example = "12321L")
    private String idCard;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", name = "sex", example = "12321L")
    private Integer sex;

    /**
     * 职务
     */
    @ApiModelProperty(value = "用户职务", name = "position")
    private Integer position;

    /**
     * 用户单位
     */
    @ApiModelProperty(value = "用户单位", name = "unitsName", example = "12321L")
    private String unitsName;

    /**
     * 用户单位id
     */
    @ApiModelProperty(value = "用户单位id", name = "unitsId", example = "12321L")
    private Integer unitsId;

    /**
     * 考勤
     */
    @ApiModelProperty(value = "考勤", name = "attendance")
    private String attendance;

    /**
     * 分数
     */
    @ApiModelProperty(value = "分数", name = "score")
    private String score;

    /**
     * 评价
     */
    @ApiModelProperty(value = "评价", name = "evaluation")
    private String evaluation;

    /**
     * 是否报名 1.报名 2.不报名
     */
    @ApiModelProperty(value = "是否报名 1.报名 2.不报名", name = "certificate")
    private Integer isSignUp;

    /**
     * 不报名的备注
     */
    @ApiModelProperty(value = "不报名的备足", name = "certificate")
    private String note;

    /**
     * 是否发证
     */
    @ApiModelProperty(value = "是否发证", name = "certificate")
    private Integer certificate;

    /**
     * 是否必须报名 1.必须 2.不必须
     */
    @ApiModelProperty(value = "是否必须报名 1.必须 2.不必须", name = "certificate")
    private Integer  isNotJoinUserId;

    @ApiModelProperty(value = "区块链RID",name = "recordId")
    private String recordId;

    @Transient
    private Mgrcert mgrcert;

}
