package com.tykj.dev.device.train.entity;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.train.entity.vo.WorkHandoverVo;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName WorkHandover.java
 * @Description TODO
 * @createTime 2020年09月17日 13:14:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@EntityListeners(AuditingEntityListener.class)
public class WorkHandover {
    /**
     * 工作交接id
     */
    @Id
    @GeneratedValue()
    @ApiModelProperty(value = "工作交接id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer workHandoverId;

    /**
     * 发起人id
     */
    private Integer  initiateUserId;

    /**
     * 交接相关人员
     */
    @Column(name = "handover_user_ids",columnDefinition = "TEXT")
    private String handoverUserIds;


    /**
     * 移交人a
     */
    @Column(name = "turn_over_user_ids",columnDefinition = "TEXT")
    private String turnOverUserIds;

    /**
     * 监交人
     */
    private String inUserName;

    /**
     * 上级领导
     */
    private String leadershipName;

    /**
     * 代办业务 json
     */
    private String commissionWord;

    /**
     * 跟踪业务 json
     */
    private String trackingWord;

    /**
     * 文件集合(装备列表签字文件集合)
     */
    @Column(name = "file" ,columnDefinition = "TEXT")
    private String file;

    /**
     * 状态 1.新建 2.完成
     */
    private Integer status=1;

    /**
     * 创建时间
     */
    @CreatedDate
    private  Date createTime;

    /**
     * 更新时间
     */
    @LastModifiedDate
    private Date updateTime;

    @ApiModelProperty(value = "区块链RID",name = "recordId")
    private String recordId;

    /**
     * 发起用户集合
     */
    @Transient
    private List<User> handoverUserList;

    /**
     * 接收用户集合
     */
    @Transient
    private List<User> turnOverUserList;

    /**
     * 接收用户集合
     */
    @Transient
    private List<FileRet> fileRets;

    /**
     * 本次交接装备信息清单
     */
    @Transient
    private List<WorkHandoverDev> workHandoverDevs;
}
