package com.tykj.dev.device.train.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName WorkHandoverDevice.java
 * @Description TODO
 * @createTime 2021年03月09日 15:52:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class WorkHandoverDev {

    @Id
    @GeneratedValue
    @ApiModelProperty(value = "数据id")
    private Integer id;

    @ApiModelProperty(value = "业务数据id")
    private Integer wordId;

    @ApiModelProperty(value = "型号", example = "bmxx")
    private String model;

    @ApiModelProperty(value = "名称", example = "BM-1")
    private String name;

    @ApiModelProperty(value = "所属单位", example = "省机要局")
    private String ownUnit;

    @ApiModelProperty(value = "装备类型总数", example = "100")
    private Integer deviceNumber;

    @ApiModelProperty(value = "在库数量", example = "10")
    private Integer inLibraryNum;

    @ApiModelProperty(value = "维修数量", example = "10")
    private Integer repairNum;

    @ApiModelProperty(value = "销毁数量", example = "10")
    private Integer destoryNum;

    @ApiModelProperty(value = "退役数量", example = "10")
    private Integer retiredNum;

    @ApiModelProperty(value = "报废数量", example = "10")
    private Integer scrappedNum;

    @ApiModelProperty(value = "运输中数量", example = "10")
    private Integer allotNum;

    @ApiModelProperty(value = "使用数量", example = "10")
    private Integer useNum;

//    @ApiModelProperty(value = "该型号所有装备Id列表")
//    @Transient
//    private List<Integer> deviceIds = new ArrayList<>();
//
//    @Transient
//    @ApiModelProperty(value = "该型号在库装备Id列表")
//    private List<Integer> inLibraryIds = new ArrayList<>();
//
//    @Transient
//    @ApiModelProperty(value = "该型号维修装备Id列表")
//    private List<Integer> repairIds = new ArrayList<>();
//
//    @Transient
//    @ApiModelProperty(value = "该型号销毁装备Id列表")
//    private List<Integer> destoryIds = new ArrayList<>();
//
//    @Transient
//    @ApiModelProperty(value = "该型号退役装备Id列表")
//    private List<Integer> retiredIds = new ArrayList<>();
//
//    @Transient
//    @ApiModelProperty(value = "该型号报废装备Id列表")
//    private List<Integer> scrappedIds = new ArrayList<>();
//
//    @Transient
//    @ApiModelProperty(value = "该型号运输中装备Id列表")
//    private List<Integer> allotIds = new ArrayList<>();
//
//    @Transient
//    @ApiModelProperty(value = "该型号使用中装备Id列表")
//    private List<Integer> useIds = new ArrayList<>();

    @ApiModelProperty(value = "序列号区间")
    @Column(name = "seq_s" ,columnDefinition = "TEXT")
    public String seqs;
}
