package com.tykj.dev.device.train.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName ConditionsTrain.java
 * @Description 培训查询类
 * @createTime 2020年08月19日 21:50:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "培训条件查询类", description = "培训条件查询类")
public class ConditionsTrainVo {
    @ApiModelProperty(value = "开始时间", example = "bmxx", name = "statusTime")
    private Integer page;

    @ApiModelProperty(value = "开始时间", example = "bmxx", name = "statusTime")
    private Integer size;

    @ApiModelProperty(value = "开始时间", example = "bmxx", name = "statusTime")
    private String dimName;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(value = "开始时间", example = "bmxx", name = "statusTime")
    private Date statusTime;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(value = "结束时间", example = "bmxx", name = "endTime")
    private Date endTime;


}
