package com.tykj.dev.device.train.entity.vo;

import com.tykj.dev.device.train.entity.TrainTheme;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TrainThemeAddVo.java
 * @Description TODO
 * @createTime 2020年08月13日 14:46:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "新建培训对象", description = "新建培训对象")
public class TrainThemeAddVo {

    /**
     * 培训主题
     */
    @ApiModelProperty(value = "培训主题")
    private String name;

    /**
     * 报名截止时间
     */
    @ApiModelProperty(value = "报名截止时间")
    private Date trainTime;
    /**
     * 发起人 originator
     */
    @ApiModelProperty(value = "发起人")
    private String originatorName;

    /**
     * 发起人 originator
     */
    @ApiModelProperty(value = "发起人id")
    private Integer originatorId;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位名称")
    private String unitsName;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位")
    private Integer unitsId;

    /**
     * 培训开始时间
     */
    @ApiModelProperty(value = "培训开始时间")
    private Date startTime;
    /**
     * 培训结束时间
     */
    @ApiModelProperty(value = "培训结束时间")
    private Date endTime;

    /**
     * 培训地点
     */
    @ApiModelProperty(value = "培训地点")
    private String trainLocation;

    /**
     * 主讲人
     */
    @ApiModelProperty(value = "主讲人")
    private String speakerUserId;

    /**
     * 培训资料名称
     */
    @ApiModelProperty(value = "培训资料")
    private String trainDataName;

    /**
     * 培训url
     */
    @ApiModelProperty(value = "培训资料")
    private String trainDataUrl;

    /**
     * 培训简介
     */
    @ApiModelProperty(value = "trainSynopsis")
    private String trainSynopsis;

//    /**
//     * 必须参加
//     */
//    @ApiModelProperty(value = "参会人员id 集合")
//    private List<Integer> joinUserIds=new ArrayList<>();
//
//    /**
//     * 不必须参会人员
//     */
//    @ApiModelProperty(value = "参会人员id 集合")
//    private List<Integer> noJoinUserIds=new ArrayList<>();


    /**
     * 需要参加的单位
     */
    @ApiModelProperty(value = "参会人员id 集合",name = "unitsIds")
    private List<Integer> unitsIds;

    /**
     * 培训状态 1报名中  2待培训  3培训中
     */
    @ApiModelProperty(value = "培训状态")
    private Integer trainStatus;

    public TrainTheme toDo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, TrainTheme.class);
    }
}
