package com.tykj.dev.device.train.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TrainTheme.java
 * @Description TODO
 * @createTime 2020年08月11日 21:35:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "培训分页对象", description = "培训分页记录")
public class TrainThemeVo {
    //培训主题
    //时间
    //主机讲人
    //状态
    @ApiModelProperty(value = "培训id", example = "10")
    private Integer trainId;

    @ApiModelProperty(value = "培训主题", example = "10")
    private String name;

    @ApiModelProperty(value = "时间", example = "10")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date trainTime;

    /**
     * 发起人 originator
     */
    @ApiModelProperty(value = "发起人")
    private String originatorName;

    @ApiModelProperty(value = "状态", example = "10")
    private Integer trainStatus;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位名称")
    private String unitsName;

    private Integer taskId;

    public TrainThemeVo(Integer trainId, String name, Date trainTime, String originatorName, Integer trainStatus, String unitsName) {
        this.trainId = trainId;
        this.name = name;
        this.trainTime = trainTime;
        this.originatorName = originatorName;
        this.trainStatus = trainStatus;
        this.unitsName = unitsName;
    }
}
