package com.tykj.dev.device.train.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TrainUpdateVo.java
 * @Description TODO
 * @createTime 2020年08月18日 23:09:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "培训更新对象", description = "培训更新对象")
public class TrainUpdateVo {
    /**
     * 培训id
     */
    @ApiModelProperty(value = "培训id")
    private Integer trainId;
    /**
     * 培训开始时间
     */
    @ApiModelProperty(value = "培训开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startTime;
    /**
     * 培训结束时间
     */
    @ApiModelProperty(value = "培训结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endTime;

    /**
     * 培训地点
     */
    @ApiModelProperty(value = "培训地点")
    private String trainLocation;

    /**
     * 主讲人
     */
    @ApiModelProperty(value = "主讲人")
    private String speakerUserId;

    /**
     * 培训资料名称
     */
    @ApiModelProperty(value = "培训资料")
    private String trainDataName;

    /**
     * 培训url
     */
    @ApiModelProperty(value = "培训资料")
    private String trainDataUrl;


    /**
     * 培训简介
     */
    @ApiModelProperty(value = "trainSynopsis")
    private String trainSynopsis;

}
