package com.tykj.dev.device.train.service.impl;

import com.tykj.dev.device.task.repository.TaskDao;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.train.service.TrainTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TrainTaskServiceImpl.java
 * @Description TODO
 * @createTime 2020年09月03日 11:16:00
 */
@Service
public class TrainTaskServiceImpl implements TrainTaskService {
    @Autowired
    TaskDao taskDao;

    @Override
    public List<TaskBto> selectBillidAndBillType(Integer billId, Integer billType, Integer billStatus) {
        return taskDao.findAllByBillIdAndBusinessTypeAndBillStatus(billId, billType, billStatus)
                .stream()
                .map(Task::parse2Bto)
                .collect(Collectors.toList());
    }

    @Override
    public TaskBto selectFatherIsNullAndBillidAndBillType(Integer billId, Integer billType) {
        return taskDao.findAllByParentTaskIdIsNullAndBillIdAndBusinessType(billId, billType).parse2Bto();
    }
}
