//package com.tykj.dev.repair;
//
//import com.alibaba.fastjson.JSONObject;
//import com.github.wenhao.jpa.Specifications;
//import com.tykj.dev.device.repair.repository.RepairDetailDao;
//import com.tykj.dev.device.repair.subject.vo.DeviceDetailVo;
//import com.tykj.dev.device.repair.subject.vo.RepairBillSaveVo;
//import com.tykj.dev.device.repair.subject.vo.RepairConfirmVo;
//import com.tykj.dev.device.repair.subject.vo.RepairReceiveVo;
//import com.tykj.dev.device.task.repository.TaskDao;
//import com.tykj.dev.device.task.subject.domin.Task;
//import com.tykj.dev.device.user.util.UserUtils;
//import com.tykj.dev.misc.base.ResultObj;
//import com.tykj.dev.misc.base.StatusEnum;
//import com.tykj.dev.union.BaseTest;
//import org.junit.Test;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.http.MediaType;
//import org.springframework.security.test.context.support.WithMockUser;
//import org.springframework.test.context.ActiveProfiles;
//import org.springframework.test.web.servlet.MockMvc;
//import org.springframework.test.web.servlet.MvcResult;
//import org.springframework.test.web.servlet.RequestBuilder;
//
//import java.util.ArrayList;
//import java.util.Comparator;
//import java.util.List;
//import java.util.stream.Collectors;
//
//import static com.tykj.dev.misc.utils.JacksonUtil.toJSon;
//import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
//import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
//import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
//
//@SuppressWarnings("ALL")
//@WithMockUser(username = "shia", password = "qwer1234", authorities = "市A专管员")
//@ActiveProfiles("test")
//public class RepairControllerTest extends BaseTest {
//
//    static int repairSendTaskId;
//    static int repairBackTaskId;
//    @Autowired
//    protected MockMvc mockMvc;
//    @Autowired
//    private TaskDao taskDao;
//    @Autowired
//    private RepairDetailDao repairDetailDao;
//    @Autowired
//    private UserUtils userUtils;
//
//    /**
//     * 发起维修运输过程单元测试
//     */
//    @Test
//    public void createRepairTest() throws Exception {
//        Integer level = userUtils.getCurrentUnitLevel();
//        RepairBillSaveVo repairBillSaveVo = new RepairBillSaveVo();
//        repairBillSaveVo.setStartUseraId(3);
//        repairBillSaveVo.setStartUserbId(4);
//        repairBillSaveVo.setApplyNumber("qweqwe");
//        repairBillSaveVo.setAgent("sadad");
//        repairBillSaveVo.setReceiveUnit("省机要局");
//        List<DeviceDetailVo> ids = new ArrayList<>();
//        ids.add(new DeviceDetailVo(21, "aaa"));
//        ids.add(new DeviceDetailVo(26, "asdasd"));
//        repairBillSaveVo.setDeviceList(ids);
//        repairBillSaveVo.setFileName("aaaa");
//        repairBillSaveVo.setFileUrl("sdfhks");
//        repairBillSaveVo.setRepairDeviceCheckDetail("x211x261x");
//        repairBillSaveVo.setRepairDeviceCheckResult("0x0");
//        repairBillSaveVo.setReplayNumber("adjskhsd");
//        repairBillSaveVo.setSendedCount(2);
//        repairBillSaveVo.setSendingCount(2);
//        repairBillSaveVo.setSendUnit("市机要局");
//        // 测试
//        RequestBuilder request;
//
//        request = post("/repair/form")
//                .header("Origin", "*")
//                .contentType(MediaType.APPLICATION_JSON)
//                .content(toJSon(repairBillSaveVo));
//
//        mockMvc.perform(request)
//                .andExpect(status().isOk())
//                .andDo(mvcResult1 -> System.out.println("[测试结果] 发起维修任务测试通过"));
//
//        Task initTask = taskDao.findAll(Specifications.<Task>and()
//                .eq("billStatus", StatusEnum.REPAIR_SEND_CONFIRM.id)
//                .build()).stream()
//                .sorted(Comparator.comparing(Task::getCreateTime).reversed())
//                .collect(Collectors.toList())
//                .get(0);
//        repairSendTaskId = initTask.getId();
//        //审核通过
//        RepairConfirmVo repairConfirmVo = new RepairConfirmVo();
//        repairConfirmVo.setStatus(0);
//        repairConfirmVo.setTaskId(initTask.getId());
//        request = post("/repair/sendConfirm")
//                .header("Origin", "*")
//                .contentType(MediaType.APPLICATION_JSON)
//                .content(toJSon(repairConfirmVo));
//
//        mockMvc.perform(request)
//                .andExpect(status().isOk())
//                .andDo(mvcResult1 -> System.out.println("[测试结果] 对任务id=" + initTask.getId() + "的任务发起维修审核成功，维修单id为" + initTask.getBillId()));
//        //如果是省向国家发起的
//        if (level == 1) {
//            System.out.println("等待国家维修装备退回");
//        } else {
//            //接收维修装备
//            RepairReceiveVo repairReceiveVo = new RepairReceiveVo();
//            repairReceiveVo.setBillFileName("adfaf");
//            repairReceiveVo.setBillFileUrl("asdas");
//            repairReceiveVo.setReceiveCheckDetail("x211x261x");
//            repairReceiveVo.setReceiveCount(2);
//            repairReceiveVo.setReceiveCheckResult("0x0");
//            repairReceiveVo.setReceiveUserbId(2);
//            repairReceiveVo.setTaskId(initTask.getId());
//
//            request = post("/repair/receive")
//                    .header("Origin", "*")
//                    .contentType(MediaType.APPLICATION_JSON)
//                    .content(toJSon(repairReceiveVo));
//
//            mockMvc.perform(request)
//                    .andExpect(status().isOk())
//                    .andDo(mvcResult1 -> System.out.println("[测试结果] 维修装备接收成功"));
//
//            //接收维修装备审核通过
//            repairConfirmVo.setStatus(0);
//            repairConfirmVo.setTaskId(initTask.getId());
//            request = post("/repair/receiveConfirm")
//                    .header("Origin", "*")
//                    .contentType(MediaType.APPLICATION_JSON)
//                    .content(toJSon(repairConfirmVo));
//
//            mockMvc.perform(request)
//                    .andExpect(status().isOk())
//                    .andDo(mvcResult1 -> System.out.println("[测试结果] 接收维修装备审核成功"));
//        }
//    }
//
//    /**
//     * 维修退回过程单元测试
//     */
//    @Test
//    public void sendBackRepairDevice() throws Exception {
//        Integer level = userUtils.getCurrentUnitLevel();
//        RequestBuilder request;
//        if (level == 2 || level == 3) {
//            request = get("/repair/backDeviceSelect/" + repairSendTaskId)
//                    .header("Origin", "*")
//                    .contentType(MediaType.APPLICATION_JSON);
//            MvcResult result = mockMvc.perform(request)
//                    .andExpect(status().isOk())
//                    .andDo(mvcResult1 -> System.out.println("[测试结果] 维修退回装备出库查询成功"))
//                    .andReturn();
//            String body = result.getResponse().getContentAsString();
//            ResultObj resultObj = JSONObject.parseObject(body, ResultObj.class);
//            System.out.println("返回值:" + resultObj.getData());
//        }
//    }
//}
