package com.tykj.dev.device.user.config;

import com.tykj.dev.device.user.subject.entity.Role;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.device.user.subject.entity.UserRole;
import com.tykj.dev.device.user.subject.service.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zjm
 */
@Service
@Slf4j
public class MyUserDetailsServiceImpl implements UserDetailsService {
    @Autowired
    PermissionsService permissionsService;
    @Autowired
    UnitsService unitsService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private RolePermissionsService rolePermissionsService;

    @Override
    public UserDetails loadUserByUsername(String username) throws BadCredentialsException {

        SecurityUser securityUser = new SecurityUser();
        User user = userService.findByUserName(username);
        if (user == null) {
            throw new BadCredentialsException("用户名填写错误");
        } else {
            if (user.getIsDel()==1){
                throw new BadCredentialsException("账号被冻结，请联系管理人员");
            }
            List<UserRole> userRoles = userRoleService.findByUserId(user.getUserId());
            List<Integer> roleIds = new ArrayList<>();
            if (userRoles != null) {
                for (UserRole userRole : userRoles) {
                    roleIds.add(userRole.getRoleId());
                }
            }
//              user.setPassword(bCryptPasswordEncoder.encode(user.getPassword()));
//                List<SimpleGrantedAuthority> list = new ArrayList<>();
            List<Role> roles = roleService.findAllByRoles(roleIds);
//                List<RolePermissions> rolePermissions = rolePermissionsService.findAllByRoleIds(roleIds);
//                List<Integer> PermissionsIds = new ArrayList<>();
//                if(rolePermissions!=null){
//                    for (RolePermissions permissions : rolePermissions) {
//                        if(!PermissionsIds.contains(permissions.getPermissionsId())){
//                            PermissionsIds.add(permissions.getPermissionsId());
//                        }
//                    }
//                }
//
//                List<Permissions> permissionsList = permissionsService.findAllByPerissionsIds(PermissionsIds);
//                permissionsList.forEach(permissions -> {
//                    list.add(new SimpleGrantedAuthority(permissions.getPermissionsDes()));
//                });
//                 user.setArrayList(list);
            user.setUnits(unitsService.findById(user.getUnitsId()));
            securityUser.setCurrentUserInfo(user);
            securityUser.setRoleList(roles);
            securityUser.setUsername(username);
            log.info("登入成功：{}",username);
            return securityUser;
        }


    }
}
