package com.tykj.dev.device.user.read.controller;

/**
 * @author dengdiyi
 */

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.user.read.service.MessageService;
import com.tykj.dev.device.user.read.subject.vo.MessageUserVo;
import com.tykj.dev.socket.MyWebSocket;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

//import com.tykj.dev.device.read.service.MessageService;

/**
 * @author dengdiyi
 */
@RestController
@Api(tags = "阅知模块", description = "阅知模块")
@AutoDocument
@RequestMapping("/read")
public class MessageController {

    @Autowired
    private MessageService messageService;

    @Autowired
    private MyWebSocket myWebSocket;

    @ApiOperation(value = "阅知信息查询")
    @GetMapping("/get")
    public ResponseEntity getMessage(){
        return ResponseEntity.ok(messageService.getList());
    }

    @ApiOperation(value = "提交已读阅知信息")
    @PostMapping("/read/{id}")
    public ResponseEntity readMessage(@PathVariable("id") int id){
        MessageUserVo m = messageService.read(id).parse2Bto().toVo();
        myWebSocket.sendMessage1();
        return ResponseEntity.ok(m);
    }

    @ApiOperation(value = "完成阅知信息")
    @PostMapping("/complete/{id}")
    public ResponseEntity completeMessage(@PathVariable("id") int id){
        return ResponseEntity.ok(messageService.complete(id).parse2Bto().toVo());
    }
}
