package com.tykj.dev.device.user.read.subject.bto;

import com.tykj.dev.device.user.read.subject.domin.Message;
import com.tykj.dev.device.user.read.subject.vo.MessageUserVo;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.device.user.util.UserUtils;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.SpringUtils;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MessageBto {

    @ApiModelProperty(name = "主键id")
    private Integer id;

    @ApiModelProperty(name = "阅知信息对应业务Id")
    private Integer taskId;

    @ApiModelProperty(value = "业务类型主键id")
    private Integer businessType;

    @ApiModelProperty(value = "信息内容")
    private String content;

    @ApiModelProperty(value = "附加信息")
    private String record;

    @ApiModelProperty(value = "阅知人员id类别")
    private List<Integer> involveUserIdList;

    @ApiModelProperty(value = "已完成人员id列表")
    private List<Integer> completeUserIdList = new ArrayList<>();

    @ApiModelProperty(value = "用户已读列表")
    private List<Integer> userReadDetailList = new ArrayList<>();

    @ApiModelProperty(value = "创建用户id")
    private Integer createUserId;

    @ApiModelProperty(value = "创建时间")
    @CreatedDate
    private Date createTime;

    @ApiModelProperty(value = "更新用户id")
    @LastModifiedBy
    private Integer updateUserId;

    @ApiModelProperty(value = "更新时间")
    @LastModifiedDate
    private Date updateTime;

    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    @ApiModelProperty(value = "是否高亮(0：不是，1：是)")
    private Integer isHighLight = 0;

    /**
     * bto类转化为do类
     */
    public Message toDo() {
        //复制相同属性
        ModelMapper modelMapper = BeanHelper.getUserMapper();
        Message message = modelMapper.map(this, Message.class);
        //set组合字段
        message.setInvolveUsers(StringSplitUtil.idListToString(this.involveUserIdList));
        message.setUserReadDetail(StringSplitUtil.idListToString(this.userReadDetailList));
        message.setCompleteUsers(StringSplitUtil.idListToString(this.completeUserIdList));
        return message;
    }

    /**
     * bto类转化为vo类
     */
    public MessageUserVo toVo() {
        UserUtils userUtils = SpringUtils.getBean("userUtils");
        UserPublicService userPublicService = SpringUtils.getBean("userPublicServiceImpl");
        //复制相同属性
        ModelMapper modelMapper = BeanHelper.getUserMapper();
        MessageUserVo messageUserVo = modelMapper.map(this, MessageUserVo.class);
        //set vo字段
        if (userUtils!=null&&userReadDetailList.contains(userUtils.getCurrentUserId())){
            messageUserVo.setIsRead(1);
        }
        if (messageUserVo.getCreateUserId()!=null){
            messageUserVo.setOperator(userPublicService.getOne(messageUserVo.getCreateUserId()).getName());
            messageUserVo.setUnit(userPublicService.findUnitsNameByUserId(messageUserVo.getCreateUserId()));
        }
        return messageUserVo;
    }

    public MessageBto(Integer taskId, Integer businessType, String content, List<Integer> involveUserIdList) {
        this.taskId = taskId;
        this.businessType = businessType;
        this.content = content;
        this.involveUserIdList = involveUserIdList;
    }

    public MessageBto(Integer taskId, Integer businessType, String content, List<Integer> involveUserIdList, Integer isHighLight) {
        this.taskId = taskId;
        this.businessType = businessType;
        this.content = content;
        this.involveUserIdList = involveUserIdList;
        this.isHighLight = isHighLight;
    }
}
