package com.tykj.dev.device.user.read.subject.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import java.util.Date;

/**
 * @author dengdiyi
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MessageUserVo {

    @ApiModelProperty(name = "主键id")
    private Integer id;

    @ApiModelProperty(name = "阅知信息对应业务Id")
    private Integer taskId;

    @ApiModelProperty(value = "业务类型主键id")
    private Integer businessType;

    @ApiModelProperty(value = "信息内容")
    private String content;

    @ApiModelProperty(name = "当前用户是否已阅读(0:未读，1:已读)")
    private Integer isRead = 0;

    @ApiModelProperty(value = "创建用户id")
    private Integer createUserId;

    @ApiModelProperty(value = "创建时间")
    @CreatedDate
    private Date createTime;

    @ApiModelProperty(value = "更新用户id")
    @LastModifiedBy
    private Integer updateUserId;

    @ApiModelProperty(value = "更新时间")
    @LastModifiedDate
    private Date updateTime;

    @ApiModelProperty(value = "附加信息")
    private String record;

    @ApiModelProperty(value = "是否高亮(0：不是，1：是)")
    private Integer isHighLight = 0;

    @ApiModelProperty(value = "操作人")
    private String operator;

    @ApiModelProperty(value = "操作人单位")
    private String unit;
}
