package com.tykj.dev.device.user.subject.controller;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName AreaController.java
 * @Description TODO
 * @createTime 2020年09月04日 13:34:00
 */

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.user.subject.dao.AreaDao;
import com.tykj.dev.device.user.subject.entity.Area;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.service.AreaService;
import com.tykj.dev.misc.exception.ApiException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.util.Optional;

/**
 * 区域视图层
 */
@RestController
@AutoDocument
@Api(tags = "区域模块", description = "提供区域模块的接口")
@RequestMapping("/area")
public class AreaController {
    @Autowired
    AreaService areaService;
    @Autowired
    AreaDao areaDao;

    @GetMapping(value = "/area/units")
    @ApiOperation(value = "查询权限接口，按照类型划分，具体字段查看model", notes = "成功返回分类的权限对象")
    public ResponseEntity addPermissions(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser) {
        return ResponseEntity.ok(areaService.findAll(securityUser.getCurrentUserInfo().getUnits().getAreaId()));
    }

    @GetMapping(value = "/select/area/{areaId}")
    @ApiOperation(value = "查询区域对象，传入areaId", notes = "成功返回区域对象")
    public ResponseEntity areaId(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer areaId) {
        Optional<Area> areaOptional = areaDao.findById(areaId);
        if (areaOptional.isPresent()) {

            return ResponseEntity.ok(areaOptional.get());
        } else {
            throw new ApiException(ResponseEntity.status(500).body("areaId查询不到"));
        }
    }

    @PostMapping("/save")
    @ApiOperation(value = "添加区域对象", notes = "成功返回区域对象")
    public ResponseEntity saveArea(@RequestBody Area area){
       return ResponseEntity.ok( areaService.save(area));
    }

    @GetMapping("/select/oneAndTwo")
    @ApiOperation(value = "查询省、市级区域的接口（下拉列表）", notes = "成功返回区域对象")
    public ResponseEntity selectOneAndTwo(){

        return ResponseEntity.ok(areaService.findOneAndTwoArea());
    }

    @GetMapping("/page/{page}/{size}")
    @ApiOperation(value = "分页查询area对象", notes = "成功返回区域对象")
    public ResponseEntity selectPage(@PathVariable Integer page, @PathVariable Integer size){

        return ResponseEntity.ok(areaService.selectPage(page,size));
    }
}
