package com.tykj.dev.device.user.subject.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.user.subject.service.GroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName GroupsController.java
 * @Description TODO
 * @createTime 2021年01月10日 14:52:00
 */
@RestController
@AutoDocument
@Api(tags = "组模块", description = "提供区域模块的接口")
@RequestMapping("/groups")
public class GroupsController {
    @Autowired
    GroupService groupService;

    @GetMapping(value = "/findAll/{type}")
    @ApiOperation(value = "组列表的查询", notes = "成功返回分类的权限对象")
    public ResponseEntity findAll(@PathVariable Integer type){
       return ResponseEntity.ok(groupService.findAll(type));
    }
}
