package com.tykj.dev.device.user.subject.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.service.UnitsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UnitsController.java
 * @Description TODO
 * @createTime 2020年07月28日 11:12:00
 */
@RestController
@AutoDocument
@Api(tags = "用户模块", description = "提供用户相关的接口")
@RequestMapping("/units")
@Slf4j
public class UnitsController {
    @Autowired
    UnitsService unitsService;

    @GetMapping(value = "/find/{unitsId}")
    @ApiOperation(value = "根据单位ID查询对象", notes = "返回单位对象")
    public ResponseEntity findUnits(@PathVariable Integer unitsId) {
        return ResponseEntity.ok(unitsService.findById(unitsId));
    }

    @GetMapping(value = "/findAll/{level}")
    @ApiOperation(value = "根据等级查询对应等级的单位集合", notes = "单位集合")
    public ResponseEntity findAll2(@PathVariable Integer level) {
        return ResponseEntity.ok(unitsService.findListById(level));
    }

    @GetMapping(value = "/findAll")
    @ApiOperation(value = "查询所有单位", notes = "单位集合")
    public ResponseEntity findAlls() {
        return ResponseEntity.ok(unitsService.findAll());
    }

    @GetMapping(value = "/area")
    @ApiOperation(value = "查询装备库、专管员左侧的区域单位列表", notes = "单位组织结构集合")
    public ResponseEntity selectOrganizationUnits(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser) {
        return ResponseEntity.ok(unitsService.findLeftNavigation(securityUser));
    }


    @GetMapping(value = "/findAll/GreaterThanEqual/{level}")
    @ApiOperation(value = "根据当前用户的单位等级，查询所有的下级单位以及自己单位", notes = "单位集合")
    public ResponseEntity GreaterThanEqualLeven(@PathVariable Integer level) {
        return ResponseEntity.ok(unitsService.findListlevenGreaterThanEqual(level));
    }

    @GetMapping(value = "/find/units/{unitsId}")
    @ApiOperation(value = "根据当前用户的单位ID查询上级单位对象", notes = "单位")
    public ResponseEntity findLastUnits(@PathVariable Integer unitsId) {
        return ResponseEntity.ok(unitsService.findByAreaId(unitsId));
    }

    @GetMapping(value = "/find/units/superior/{unitsId}")
    @ApiOperation(value = "根据当前用户的单位ID查询下级单位对象", notes = "单位")
    public ResponseEntity findLastUnits1(@PathVariable Integer unitsId) {
        return ResponseEntity.ok(unitsService.findBySubordinate(unitsId));
    }


    @GetMapping(value = "/find/units/subordinate/{unitsId}")
    @ApiOperation(value = "根据当前用户的单位ID查询下级单位对象（不包括type为2的）", notes = "单位")
    public ResponseEntity findLastSubordinate(@PathVariable Integer unitsId) {
        return ResponseEntity.ok(unitsService.findSubordinateList(unitsId));
    }


    @PostMapping(value = "/save")
    @ApiOperation(value = "添加单位接口", notes = "单位")
    public ResponseEntity saveUnits(@RequestBody Units units){
        return ResponseEntity.ok(unitsService.save(units));
    }

    @GetMapping("/page/{page}/{size}")
    @ApiOperation(value = "分页查询units对象", notes = "成功返回区域对象")
    public ResponseEntity selectPage(@PathVariable Integer page, @PathVariable Integer size){
        return ResponseEntity.ok(unitsService.selectPage(page,size));
    }

    @GetMapping("/train/list/{unitsId}")
    @ApiOperation(value = "清退时选择培训单位的接口", notes = "成功返回单位对象")
    public ResponseEntity selectPage( @PathVariable Integer unitsId){
        return ResponseEntity.ok(unitsService.findByUserIdUnitsTrainListVo(unitsId));
    }


    @GetMapping("/countries/units")
    @ApiOperation(value = "省入库发件单位下拉接口", notes = "省入库发件单位下拉接口")
    public ResponseEntity findSuperiorUnitsList(){
        return ResponseEntity.ok(unitsService.findSuperiorUnitsList());
    }


    @GetMapping("/countries/directlyUnder")
    @ApiOperation(value = "省直属单位接口", notes = "省直属单位接口")
    public ResponseEntity directlyUnder(){
        return ResponseEntity.ok(unitsService.findDirectlyUnder());
    }



}
