package com.tykj.dev.device.user.subject.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.user.base.ret.UserConditionsVo;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.service.RoleService;
import com.tykj.dev.device.user.subject.service.UnitsService;
import com.tykj.dev.device.user.subject.service.UserRoleService;
import com.tykj.dev.device.user.subject.service.UserService;
import com.tykj.dev.device.user.util.LogoutUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UserController.java
 * @Description TODO
 * @createTime 2020年07月28日 09:02:00
 */
@RestController
@AutoDocument
@Api(tags = "专管员", description = "提供用户相关的接口")
@RequestMapping("/user")
@Slf4j
public class UserArchivesController {
    @Autowired
    UserService userService;

    @Autowired
    RoleService roleService;

    @Autowired
    UserRoleService userRoleService;

    @Autowired
    UnitsService unitsService;

    @Autowired
    LogoutUtil logout;
//

    @PostMapping(value = "/archives/summary/page")
    @ApiOperation(value = "根据单位id查询用户接口(分页)", notes = "成功返回用户对象集合")
    public ResponseEntity findAllPage(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody UserConditionsVo userConditionsVo) {

        return ResponseEntity.ok(userService.findAllByUnitePage(userConditionsVo));
    }

    @GetMapping(value = "/archives/summary/{unitsId}")
    @ApiOperation(value = "根据用户ID查询用户详情", notes = "成功返回用户对象集合")
    public ResponseEntity findAllUser(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer unitsId) {

        return ResponseEntity.ok(userService.findAllByUnite(unitsId));
    }

    @GetMapping(value = "/archives/detail/{userId}")
    @ApiOperation(value = "根据单位id查询用户接口(不分页)", notes = "成功返回用户对象集合")
    public ResponseEntity findByIdUser(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer userId) {

        return ResponseEntity.ok(userService.findById(userId));
    }


}
