package com.tykj.dev.device.user.subject.entity;

import com.tykj.dev.device.user.base.ret.AreaVo;
import com.tykj.dev.device.user.base.ret.LeftNavigation;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.persistence.*;
import java.util.UUID;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Area.java
 * @Description 地区
 * @createTime 2020年07月28日 09:46:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "地区对象", description = "地区详细信息")
public class Area {
    /**
     * 区域id
     */
    @Id
    @GeneratedValue
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    /**
     * 区域名称
     */
    private String name;

    /**
     * 等级 等级 0国家级 1省级 2市级 3县级
     */
    private Integer type;

    /**
     * 排序
     */
    private String orders;

    /**
     * 父类id
     */
    private Integer fatherId;

    /**
     * 父类名称
     */
    @Transient
    private String fatherName;


//    @Transient
//    private List<Units> units;

    public static Area empty() {
        return new Area(0, "不存在的地区", 0, "0", 0,"");
    }

    public AreaVo toVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, AreaVo.class);
    }

    public LeftNavigation toLeftNavigation(){
        return new LeftNavigation(id,name,null, UUID.randomUUID().toString(),1,Double.valueOf(orders).intValue());
    }

}
