package com.tykj.dev.device.user.subject.entity;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Group.java
 * @Description TODO
 * @createTime 2021年01月09日 12:00:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "组对象", description = "组对象详细信息")
public class Groups {
    /**
     * 组id
     */
    @Id
    @GeneratedValue
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    /**
     * 组的类型 1。单位组
     */
    private Integer type;

    /**
     * 组的名称
     */
    private String name;

    /**
     * 对应的组成员id ，分割
     */
    private String memberId;



    @Transient
    private List<Integer> members;


    @Transient
    private List<Units> unitsList;
}
