package com.tykj.dev.device.user.subject.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Mgrcert.java
 * @Description 证书
 * @createTime 2020年08月06日 14:48:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "证书", description = "证书详细信息")
public class Mgrcert {
    /**
     * id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(value = "数据ID", name = "permissionsId", example = "12321L")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;
    /**
     * 持件人名称
     */
    @ApiModelProperty(value = "持件人名称", name = "name", example = "12321L")
    private String name;
    /**
     * 持件人id
     */
    @ApiModelProperty(value = "持件人id", name = "userId", example = "12321L")
    private Integer userId;
    /**
     * 证书编号
     */
    @ApiModelProperty(value = "证书编号", name = "certNum", example = "12321L")
    private Integer certNum = 123412312;
    /**
     * 颁发日期
     */
    @ApiModelProperty(value = "颁发日期", name = "issueDate", example = "12321L")
    private Date issueDate;
    /**
     * 失效日期
     */
    @ApiModelProperty(value = "失效日期", name = "expiryDate", example = "12321L")
    private Date expiryDate;
    /**
     * 是否失效 默认0 1失效
     */
    @ApiModelProperty(value = "是否失效 默认0 1失效", name = "isExpiry", example = "12321L")
    private Integer isExpiry;
    /**
     * 证书名称
     */
    @ApiModelProperty(value = "证书名称", name = "certName", example = "12321L")
    private String certName;

}
