package com.tykj.dev.device.user.subject.entity;


import com.tykj.dev.config.cache.ConfigCache;
import com.tykj.dev.device.user.base.ret.HandoverUser;
import com.tykj.dev.device.user.base.ret.MemberThat;
import com.tykj.dev.device.user.base.ret.UserShenRe;
import com.tykj.dev.device.user.base.ret.UserSuperiorVo;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.SpringUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.modelmapper.ModelMapper;

import javax.persistence.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName User.java
 * @Description 用户对象
 * @createTime 2020年07月27日 11:19:00
 */

@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "用户对象", description = "用户详细信息")
@SQLDelete(sql = "update user set is_del = 1 where id = ?")
public class User {
    /**
     * 用户
     */

    @Id
    @GeneratedValue
    @Column(columnDefinition = "INT4 AUTO_INCREMENT")
    @ApiModelProperty(value = "用户数据ID", name = "userId", example = "12321L")
//    @GeneratedValue(generator="UserIdentityGenerator",strategy = GenerationType.AUTO)
//    @GenericGenerator(name = "UserIdentityGenerator", strategy = "UserIdentityGenerator")
    private Integer userId;

    /**
     * 真实名称
     */
    @ApiModelProperty(value = "真实名称", name = "name", example = "12321L")
    private String name;

    /**
     * 加密后密码
     */
    @ApiModelProperty(value = "密码", name = "mPassWord", example = "12321L")
    private String password;

    /**
     * 未加密密码
     */
    @ApiModelProperty(value = "密码", name = "mPassWord", example = "12321L")
    private String noPassword;

    /**
     * 用户名
     */
    @ApiModelProperty(value = "用户名", name = "userName", example = "12321L")
    private String username;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序", name = "showOrder", example = "12321L")
    private Integer showOrder;

    /**
     * 移动电话
     */
    @ApiModelProperty(value = "移动电话", name = "mobile", example = "12321L")
    private String mobile;

    /**
     * 机座
     */
    @ApiModelProperty(value = "机座", name = "telphone", example = "12321L")
    private String telphone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱", name = "email", example = "12321L")
    private String email;

    /**
     * 真传
     */
    @ApiModelProperty(value = "真传", name = "fax", example = "12321L")
    private String fax;

    /**
     * 状态 默认0、1表示冻结
     */
    @ApiModelProperty(value = "状态", name = "isDel", example = "12321L")
    private Integer isDel = 0;

    /**
     * 身份证
     */
    @ApiModelProperty(value = "身份证", name = "idCard", example = "12321L")
    private String idCard;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", name = "sex", example = "12321L")
    private Integer sex;

    /**
     * 用户单位
     */
    @ApiModelProperty(value = "用户单位", name = "unitsId", example = "12321L")
    private Integer unitsId;

    /**
     * 职务
     */
    @ApiModelProperty(value = "用户职务", name = "position")
    private Integer position;

    /**
     * 培训状态 0.已培训 1.已过期 2.未培训 3.快过期 5.不是专管员
     */
    private Integer trainStatus=2;
    /**
     * 单位对象
     */
    @Transient
    private Units units;

    public static User toDb() {
        return new User(
                null,
                " ",
                "1234",
                "sa",
                "",
                1,
                "1234",
                "1234",
                "123@qq.com",
                "123", 0, "360218199801052634", 0, 0, null, 0
                , null
        );
    }


    public MemberThat toVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        MemberThat memberThat = mapper.map(this, MemberThat.class);
        ConfigCache configCache = SpringUtils.getBean("initConfigCache");
        if (configCache!=null){
            memberThat.setPositionName(configCache.getPositionMap().get(memberThat.getPosition()));
        }
        return memberThat;
    }

    public HandoverUser toHandoverUserVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, HandoverUser.class);
    }


    public UserSuperiorVo toUserSuperiorVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, UserSuperiorVo.class);
    }

    public UserShenRe toRe() {
        return new UserShenRe(userId, name, trainStatus,showOrder);
    }

}
