package com.tykj.dev.device.user.subject.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UserLog.java
 * @Description 用户日志对象
 * @createTime 2020年12月01日 14:37:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "用户日志对象", description = "用户log")
public class UserLog {
    @Id
    @GeneratedValue
    @ApiModelProperty(value = "id", name = "id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;
    @ApiModelProperty(value = "用户id", name = "userId")
    private Integer userId;
    @ApiModelProperty(value = "时间", name = "time")
    private Date time;
    @ApiModelProperty(value = "内容", name = "content")
    private String content;

    public UserLog(Integer userId, Date time, String content) {
        this.userId = userId;
        this.time = time;
        this.content = content;
    }
}
