package com.tykj.dev.device.user.subject.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UserRole.java
 * @Description 用户角色关联表
 * @createTime 2020年07月27日 14:41:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "用户角色关联对象", description = "用户角色关联详细信息")
public class UserRole {
    /**
     * id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(value = "数据ID", name = "urId", example = "12321L")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
//    @GeneratedValue(generator="UserIdentityGenerator",strategy = GenerationType.AUTO)
//    @GenericGenerator(name = "UserIdentityGenerator", strategy = "UserIdentityGenerator")
    private Integer urId;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId", example = "12321L")
    private Integer userId;

    /**
     * 角色id
     */
    @ApiModelProperty(value = "角色id", name = "roleId", example = "12321L")
    private Integer roleId;

    public UserRole(Integer userId, Integer roleId) {
        this.userId = userId;
        this.roleId = roleId;
    }
}
