package com.tykj.dev.device.user.subject.service;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName PublicService.java
 * @Description 通用接口
 * @createTime 2020年07月27日 14:52:00
 */
public interface PublicService<T> {
    /**
     * 通用新增接口
     *
     * @param t 对象
     * @return 对象
     */
    T save(T t);

    /**
     * 根据id删除数据
     *
     * @param id 数据id
     * @return 布尔
     */
    boolean delete(Integer id);

    /**
     * 查询所有数据
     *
     * @return 数据集合
     */
    List<T> findAll();

    /**
     * 更新数据
     *
     * @param t 对象
     * @return 对象
     */
    T update(T t);

}
