package com.tykj.dev.device.user.subject.service;

import com.tykj.dev.device.user.base.ret.*;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.entity.Units;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UnitsService.java
 * @Description 单位逻辑层
 * @createTime 2020年07月28日 10:05:00
 */
public interface UnitsService extends PublicService<Units> {

    Units findById(Integer unitId);

    Units findbyName(String name);

    /**
     * 根据区域id查询区域下的单位
     */
    Units findUnitAreaId(Integer areaId);

    /**
     * 下级全部单位
     * @param leven 等级
     * @return
     */
    List<Units> findListById(Integer leven);


    /**
     * 装备管理 人员管理 组织结构列表
     * @param securityUser
     * @return
     */
    List<AreaVo> findListAreaUnitsVo(SecurityUser securityUser);

    List<Units> findListlevenGreaterThanEqual(Integer leven);



    /**
     * 查询下属单位id集合
     *
     * @param unitsId 单位id
     * @return 下属单位id集合
     */
    List<Integer> findListSubordinateId(Integer unitsId);


    /**
     * 查询下属单位id集合
     *
     * @param areaId 单位id
     * @return 下属单位id集合
     */
    List<UnitsVo> findListVoSubordinateAreaId(Integer areaId);

    /**
     * 根据区域id查看区域对象
     *
     * @param areaId 单位id
     * @return 单位id集合
     */
    List<UnitsVo> findListVoAreaId(Integer areaId);


    List<UnitsTrainVo> findListUnitsTrainVo(Integer unitsId);

    /**
     * 根据单位ID查询上级单位id集合
     *
     * @param unitsId 单位id
     * @return 上级单位ID集合
     */
    List<Integer> findSuperiorByunitsId(Integer unitsId);

    /**
     * 根据单位查询上级对象
     *
     * @param unitsId 区域id
     * @return 单位对象
     */
    Units findByAreaId(Integer unitsId);

    /**
     * 根据单位id查询下级级对象
     *
     * @param unitsId 单位id
     * @return 单位对象
     */
    List<Units> findBySubordinate(Integer unitsId);

    /**
     * 根据单位id查询下级单位名称集合
     *
     * @param unitsId 单位id
     * @return 单位对象
     */
    List<String> findBySubordinateUnitName(Integer unitsId);


    UnitsPage selectPage(Integer page, Integer size);

    /**
     * 根据用户查询 可当前单位的下级单位
     * @param userId 当前用户id
     * @return 单位集合
     */
    List<Units> findByUserIdUnitsTrainListVo(Integer unitsId);

    /**
     * 根据id的集合查询单位集合
     */
    List<Units> findAllByIdIn(List<Integer> ids);

    List<Units> finAllDirectlUnderUnits();


    /**
     * 左边侧面导航栏接口
     */
    LeftNavigation findLeftNavigation(SecurityUser securityUser);


    /**
     * 省入库上级单位对象查询接口
     */
    List<Units> findSuperiorUnitsList();

    List<Units> findDirectlyUnder();

    List<Units> findSubordinateList(Integer unitsId);
}
