package com.tykj.dev.device.user.subject.service;


import com.tykj.dev.device.user.base.req.DropDownUserLocation;
import com.tykj.dev.device.user.base.req.NotIsUser;
import com.tykj.dev.device.user.base.req.UnitNameVo;
import com.tykj.dev.device.user.base.ret.*;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.entity.User;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UserService.java
 * @Description 用户角色关联逻辑层
 * @createTime 2020年07月27日 13:12:00
 */
public interface UserService extends PublicService<User> {
    /**
     * 根据用户名查询用户对象
     *
     * @param userName
     * @return
     */
    User findByUserName(String userName);

    User save(User user, SecurityUser securityUser);

    /**
     * 查询同级人员
     *
     * @param userId
     * @return
     */
    List<UserShenRe> findByUserId(Integer userId);

    /**
     * 根据单位ID查询人员列表
     */
    List<UserShenRe> findByUniteId(Integer unitsId);


    /**
     * 根据单位ID查询人员列表（包括自己）
     */
    List<UserShenRe> findByUniteId1(Integer unitsId);


    /**
     * 根据单位id查询用户
     */
    List<User> findAllByUnite(Integer unitsId);

    /**
     * 根据单位id查询用户分页
     */
    UserPage findAllByUnitePage(UserConditionsVo userConditionsVo);


    /**
     * 修改密码
     */
    Integer updatePw(UserUpdatePw userUpdatePw);

    /**
     * 根据用户ID查询用户详情
     *
     * @param userId 用户id
     * @return 用户详情
     */
    MemberThat findById(Integer userId);

    /**
     * 根据用户ID查询用户详情
     *
     * @param userId 用户id
     * @return user

     */
    User findByUser(Integer userId);

    /**
     * 根据用户ID查询下级所有用户
     *
     * @param userId 用户ID
     * @return 用户集合
     */
    List<User> findSubordinate(Integer userId);

    /**
     * 根据用户ID查询下级所有用户 UserTrainVo
     *
     * @param userId 用户ID
     * @return 用户集合
     */
//    List<UserTrainVo> findByIdUserTarinVo(Integer userId);


    /**
     * 根据用户ID查询下级单位集合 UnitsTrainVo
     *
     * @param userId 用户ID
     * @return 用户集合
     */
    List<UnitsTrainVo> findByIdUnitsTrainVo(Integer userId);

    /**
     * 返回培训用户
     *
     * @param userId
     * @return
     */
//    List<UserTrainVo> findByIdListUserTarinVo(List<Integer> userId);


    /**
     * 根据用户ID查询用户详情（工作交接）
     *
     * @param userId 用户id
     * @return 用户详情
     */
    HandoverUser findByIdHandoverUser(Integer userId);


    /**
     * 根据用户ID查询上级单位所有用户
     */
    List<UserSuperiorVo> findUserSuperiorVo(Integer userId);


    /**
     * 根据单位id集合查询用户
     */
    List<User> findUnitsIdInUsers(List<Integer> units);


    /**
     * 根据用户id集合查询用户
     */
    List<User> findAllUserIdInUser(List<Integer> userIds);

    /**
     * 根据单位id查询 上级的用户id
     */
    List<Integer> findAllLastUserids(Integer userId);


    /**
     * 重制用户的密码
     */
    void updateUserPass();


    /**
     * 不是专管员添加接口
     */
    User addNoIsUser(NotIsUser notIsUser);

    /**
     * 人员位置下拉列表选中接口
     * 根据单位id 选中人员 以及位置 替换对应人员的位置
     * 提供给前端默认选中
     */
    void  replaceOptFor(DropDownUserLocation dropDownUserLocation);

    /**
     * 根据单位名称查询单位下的人员
     * @param unitNameVo 单位名称对象
     * @return 人员集合
     */
    List<UserShenRe> findUnitNameListUser(UnitNameVo unitNameVo);
}
