package com.tykj.dev.device.user.subject.service.impl;

import com.tykj.dev.device.user.base.ret.RolePage;
import com.tykj.dev.device.user.subject.dao.RoleDao;
import com.tykj.dev.device.user.subject.dao.RolePermissionsDao;
import com.tykj.dev.device.user.subject.dao.UserRoleDao;
import com.tykj.dev.device.user.subject.entity.Role;
import com.tykj.dev.device.user.subject.entity.RolePermissions;
import com.tykj.dev.device.user.subject.service.PermissionsService;
import com.tykj.dev.device.user.subject.service.RolePermissionsService;
import com.tykj.dev.device.user.subject.service.RoleService;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RoleServiceImpl.java
 * @Description 角色逻辑层
 * @createTime 2020年07月27日 15:06:00
 */
@Service
public class RoleServiceImpl implements RoleService {
    @Autowired
    RoleDao roleDao;

    @Autowired
    RolePermissionsService rolePermissionsService;

    @Autowired
    PermissionsService permissionsService;

    @Autowired
    UserRoleDao userRoleDao;

    @Autowired
    RolePermissionsDao rolePermissionsDao;

    @Override
    public Role save(Role role) {
        return roleDao.save(role);
    }

    @Override
    public boolean delete(Integer id) {
        roleDao.deleteById(id);
        rolePermissionsDao.deleteAllByRoleId(id);
        userRoleDao.deleteAllByRoleId(id);
        return true;
    }

    @Override
    public List<Role> findAll() {
        return roleDao.findAll();
    }

    @Override
    public Role update(Role role) {
        return roleDao.save(role);
    }

    @Override
    public List<Role> findAllByRoles(List<Integer> ids) {
        return roleDao.findAllByRoleIdIn(ids);
    }

    @Override
    public RolePage findByUserRolePage(Integer page, Integer size) {
        Pageable pageable = PageRequest.of(page, size, Sort.Direction.ASC, "createTime");
        Page<Role> rolePage = roleDao.findAll(pageable);
        return RolePage.builder().data(rolePage.getContent())
                .page(page)
                .size(size)
                .total(Math.toIntExact(rolePage.getTotalElements()))
                .build();
    }

    @Override
    public Role findById(Integer roleId) {
        Optional<Role> roleOpt = roleDao.findById(roleId);
        if (roleOpt.isPresent()) {
            Role role = roleOpt.get();
            List<Integer> permissionIds = rolePermissionsService.findAllByRoleId(role.getRoleId()).stream().map(RolePermissions::getPermissionsId).collect(Collectors.toList());
            role.setPermissions(permissionsService.findAllByPerissionsIds(permissionIds));
            return role;
        } else {
            return new Role();
        }

    }


}
